#include<DCmotor.hpp>

DCmotor::DCmotor(Port motor, float max_pwm, float min_pwm, bool CW_flag):motor_(motor),max_pwm_(max_pwm),min_pwm_(min_pwm),CW_flag_(CW_flag){
}

DCmotor::DCmotor(PinName pin_a, PinName pin_b, float max_pwm, float min_pwm, bool CW_flag):max_pwm_(max_pwm),min_pwm_(min_pwm),CW_flag_(CW_flag){
    motor_.pin[0] = pin_a;
    motor_.pin[1] = pin_b;
}

void DCmotor::drive(float pwm){
    float output_pwm = (abs(pwm) < min_pwm_ ? min_pwm_ : abs(pwm) > max_pwm_ ? max_pwm_ : abs(pwm));
    pwm = (CW_flag_ == false ? -pwm : pwm);
    if(!pwm) {
        DigitalOut Moter1(motor_.pin[0],0);
        DigitalOut Moter2(motor_.pin[1],0);
    } else if(pwm < 0) {
        PwmOut Moter1(motor_.pin[0]);
        Moter1.period_us(256);
        Moter1.write(output_pwm);
        DigitalOut Moter2(motor_.pin[1],0);
    } else {
        DigitalOut Moter1(motor_.pin[0],0);
        PwmOut Moter2(motor_.pin[1]);
        Moter2.period_us(256);
        Moter2.write(output_pwm);
    }
}
