#ifndef NEOPIXEL_H
#define NEOPIXEL_H
#include "mbed.h"
#include <vector>

/*
// Example

NeoPixelOut npx(D12,6);//出力ピン　LEDの個数

int main() {
    wait(0.2); // wait for HSE to stabilize
    
    npx.global_scale = 1.0f; // Adjust brightness　明るさを変えるとき以外書かなくていいよ。
    npx.normalize = false; // Equalize brightness to make r + g + b = 255
    
    npx.setPixelColor(0,0xff0000);
    npx.setPixelColor(1,0xffff00);
    npx.setPixelColor(2,0x00ff00);
    npx.setPixelColor(3,0x00ffff);
    npx.setPixelColor(4,0x0000ff);
    npx.setPixelColor(5,0xff00ff);
    
    npx.show();
    
    while(1);
}

または、
    Pixel strip[6];
    strip[0].hex = 0xff0000;
    strip[1].hex = 0xffff00;
    strip[2].hex = 0x00ff00;
    strip[3].hex = 0x00ffff;
    strip[4].hex = 0x0000ff;
    strip[5].hex = 0xff00ff;

    npx.send(strip, 6);

*/


/**
 * @brief Struct for easy manipulation of RGB colors.
 *
 * Set components in the xrgb.r (etc.) and you will get
 * the hex in xrgb.num.
 */
union Pixel {
    /** Struct for access to individual color components */
    struct __attribute__((packed)) {
        uint8_t b;
        uint8_t g;
        uint8_t r;
        uint8_t a; // unused
    };

    /** RGB color as a single uint32_t */
    uint32_t hex;
};


class NeoPixelOut : DigitalOut {
private:
    inline void byte(uint32_t b);
    int num_pixels_;
    Pixel buf_;
    vector<Pixel> strip_;
    
public:
    bool normalize;
    float global_scale; 

    NeoPixelOut(PinName pin, int num = 0);
    
    void send(Pixel *colors, uint32_t count, bool flipwait=true);//pixel変数の配列と個数を渡してLEDに送信する。
    void changeNum(uint32_t num);//LEDの個数の変更
    void setBrightness(float brightness);//0～1
    void setPixelColor(uint32_t i,uint8_t b,uint8_t g,uint8_t r);//rgbそれぞれ個別に明るさを設定する。
    void setPixelColor(uint32_t i,uint32_t color);//この関数でそれぞれのLEDの明るさを指定し
    void show(bool flipwait=true);//この関数を呼び出してLEDに信号を送ってください。
    void off(bool flag = true);//LEDを消す。flagは、送信するかしないか。デフォルトでする。
    uint32_t color(uint8_t b,uint8_t g,uint8_t r);
    int numPixels();//LEDの個数を返す。クラス宣言時に指定した数と同じ。
    
    /** Wait long enough to make the colors show up */
    void flip(void);
};


#endif /* NEOPIXEL_H */