#include<pid.hpp>

Pid::Pid(double get_Kp,double get_Ki,double get_Kd,int plumi){
    setGain(get_Kp,get_Ki,get_Kd);
    e_o = 0;
    e_c = 0;
    plusminus=plumi;
}

double Pid::returnVal(double get_target,double input_val,double time){
    target = get_target;
    e_c = target - input_val;
    Give_P = Kp * e_c;
    Give_I=Ki*((e_o+e_c)/2.0/time);
    Give_D=Kd*(e_c-e_o)*time;
    e_o = e_c;
    Operation_amount = plusminus * Operation_amount + Give_P+Give_I-Give_D;
    if(Operation_amount > max_val){
        Operation_amount = max_val;
    }else if(Operation_amount < minimum_val){
        Operation_amount = minimum_val;
    }
    if(target == input_val){
        Operation_amount = 0;
    }
    return Operation_amount;
}

void Pid::setGain(double get_Kp,double get_Ki,double get_Kd){
    Kp = get_Kp;
    Ki = get_Ki;
    Kd = get_Kd;
}

void Pid::setMax(double get_max,double get_min){
    max_val = get_max;
    minimum_val = get_min;    
}

void Pid::reset(){
    Give_P = 0;
    Give_I = 0;
    Give_D = 0;
    e_o = 0;
    e_c = 0;    
}