#pragma once
#include<mbed.h>
#include <portSet.hpp>
#include <rotary_inc_sp.hpp>

inline double constrain(double x,double minimum,double maximum){
    return (x < minimum ? minimum : x > maximum ? maximum : x);
}

class IMC_motor
{
public:
    IMC_motor(Port encoder,int resolution,double wheel_ensyu,Port motor_,double K_,double Tau_,double dt_);
    void IMCdrive(double target);
    void drive(int pwm);
    RotaryInc motor_enc;
//private: 
    double imc_out(double target);
    double imc_controler(double y);
    double process_model(double x,double mv);
    double process_model_val;
    double out_pwm;
    double K;
    double Tau;
    double dt;
    Port motor;
};