#include "mbed.h"
#include "SCP1000.h"
#include "SHTx/sht15.hpp"
#include "WeatherMeters.h"
 
Serial Xbee1(p13, p14);
DigitalOut rst1(p16);

SCP1000 scp1000(p5,p6,p7,p17);

SHTx::SHT15 sensor(p28, p27);

AnalogIn ain(p20);
DigitalOut busy(LED1);

Serial pc(USBTX, USBRX);

WeatherMeters station(p8, p15, p10, Weather_auto);

float w_speed = 0.0;
float w_direction = 0.0;
float w_raingauge = 0.0;

char a = 'T';
char data[15];
 
void xbeesend(float x)
{
    sprintf(data, "%5.1f", x);
        
    int i = 0;
    while (data[i] != NULL)
    {
        Xbee1.putc(data[i]);
        i++;
    }

    Xbee1.putc (' ');
}
 
int main() {

    rst1 = 0;   //Set reset pin to 0
    wait_ms(1);
    rst1 = 1;   //Set reset pin to 1
    wait_ms(1);
   
    while(1) {               
              
        w_speed = station.get_windspeed();
        w_direction = station.get_windvane();
        w_raingauge = station.get_raingauge();
        
        pc.printf("Wind speed: %4.1f m/s\r\n", w_speed);
        Xbee1.putc ('S');
        xbeesend (w_speed);
        
        pc.printf("Wind direction: %4.0f\r\n", w_direction);
        xbeesend (w_direction);
        
        pc.printf("Rain Gauge: %4.1f\r\n\n", w_raingauge);
        xbeesend (w_raingauge);
     
        
        busy = true;
        sensor.update();
        busy = false;     
        
        sensor.setOTPReload(false);
        sensor.setResolution(true);
 
        sensor.setScale(false);
        pc.printf("Temperature [ %3.1f C ]\r\n", sensor.getTemperature());

        xbeesend (sensor.getTemperature());
        
        pc.printf("Humdity     [ %3.1f %% ]\r\n\n", sensor.getHumidity());
        xbeesend (sensor.getHumidity());
       
        pc.printf("The pressure is %d Pa \r\n\n", scp1000.readPressure());
        xbeesend (scp1000.readPressure());
        
        pc.printf("Sun light intensity is %3.1f %%\r\n\n", ain * 100);
        xbeesend (ain * 100);
        
        Xbee1.putc ('@');

        wait(5);
    }
}

