// - Weather Warning Alert System Receiver

#include "mbed.h"
#include "NokiaLCD.h"

Serial Xbee1(p13, p14);                                 // TX, RX
I2C radio(p28, p27);                                    // sda, scl
NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610);        // mosi, sclk, cs, rst, type LCD6610, PCF8833
DigitalOut Weather_rst(p29);                            // Weather band radio reset
DigitalOut rst1(p26);                                   // Xbee reset
DigitalOut beep(p21);                                   // Piezo speaker
DigitalOut MyRx(LED1);                                  // Data receive
DigitalIn cancel(p20);                                  // Acknowledge alert

//====================================== Global Variables =============================================
const int write_addr=0x22;                          
int wb_pwr_up[3]={0x01, 0x13, 0x05};                    // Weather band power-up command
int wb_station[4]={0x50, 0x00, 0xFD, 0xFC};             // Set weather band station to 162.55MHz
int reg_station=0xFDFC, i=0, Response, ack=0, pwr_down=0x11, tune=0x31;
int count,j;
int* p_pwr_down = &pwr_down;
int* p_tune = &tune;
float f = 162.5500;
float wndspd=0, wnddir=0,rngg=0,temp=0,humdty=0,press=0,sunint=0;
char c;
char t[100],                                            // Debug String ==> S1.2 34.5 6.7 89.0 12.8 34.5 67890.1@
ws[10], wd[10], rg[10], tp[10], hd[10], ps[10], sn[10]; 
bool alert=0;

//=============================== Support Functions for WB Radio ======================================
void SendCommand(int* array, int length) {              /* Send Command to Si4707 */
    radio.start();
    ack=radio.write(write_addr);
    for(i=0; i<length; i++) ack=radio.write(array[i]);
    Response=radio.read(ack);
    radio.stop();
    wait(.2);
}
    
void Reset(void) {                                      /* Reset weather band radio */
    Weather_rst=0;
    wait(.2);
    Weather_rst=1;
    wait(.2);
}

void WB_Restart(void) {                                 /* Reinitialize Weather band receiver */                          
    SendCommand(p_tune, 1);                             // Disable carrier
    wait(.2);
    SendCommand(p_pwr_down, 1);                         // Power down sequence
    wait(.2); 
    Reset();
    SendCommand(wb_pwr_up, 3);                          // Launch Weather band radio
    wait(.5);
    SendCommand(wb_station, 4);                         // Play current weather band station
}
 
// =========================================== Main Program ===========================================
int main() {
    cancel.mode(PullUp);
    beep=0;
    MyRx=0;
    rst1 = 0;   
    wait_ms(200);
    rst1 = 1;                                           // Reset Xbee
    radio.frequency(100000);                            // I^2C frequency setting 100kHz
    lcd.cls();                                          // Clear LCD 
    lcd.background(0x0000FF);                           // Set LCD background to blue  
    while(1) {
        if(alert) {
            beep=1; 
            wait(1);
            beep=0; 
            wait(1);
            beep=1; 
            wait(1);
            beep=0; 
            wait(1);
            beep=1; 
            wait(1);
            beep=0; 
            wait(1);
            beep=1; 
            wait(1);
            beep=0; 
            wait(1);
            Reset();                                            
            WB_Restart();                               // Start WB radio
            while(cancel);                              // Wait for user response
            alert=0;
            lcd.cls();
            lcd.background(0x0000FF);
            SendCommand(p_tune, 1);                     
            wait(.2);
            SendCommand(p_pwr_down, 1);                 // Stop WB radio
            wait(.2); 
        }
        if(Xbee1.readable()) {                          // Data available to receive
           c=Xbee1.getc();
           if(c=='A') alert=1;                          // Send 'A' on serial port to sound speaker
           if(c=='S'){                                  // Beginning of data array
                int i=0;                                
                while((c=Xbee1.getc())!='@')            // Loop until terminator reached
                    t[i++]=c;
                t[i]='\0';
                count=0;
                j=0;  
                MyRx=1;
                wait_ms(200);
                MyRx=0;                
                for(int i=0; i<sizeof(t); i++) {        // Parse data array
                    if(t[i]=='\0') break;
                    if(t[i]==' ') continue;
                    if((t[i]!=' ')&&(t[i-1]==' ')) {
                        j=0;
                        count++;
                    }
                    switch(count) {                     // Space count of data array
                        case 1:                         // Build wind speed subarray
                            ws[j++]=t[i];
                            break;
                        case 2:                         // Build wind direction subarray
                            wd[j++]=t[i];               
                            break;
                        case 3:                         // Build rain gauge subarray
                            rg[j++]=t[i];
                            break;
                        case 4:                         // Build temperature subarray
                            tp[j++]=t[i];
                            break;
                        case 5:                         // Build humidity subarray
                            hd[j++]=t[i];
                            break;
                        case 6:                         // Build pressure subarray
                            ps[j++]=t[i];
                            break;
                        case 7:                         // Build sunlight intensity subarray
                            sn[j++]=t[i];
                            break;
                        default:;
                    }
                }
                wndspd=atof(ws);
                wnddir=atof(wd);
                rngg=atof(rg);
                temp=atof(tp);
                humdty=atof(hd);
                press=atof(ps);
                sunint=atof(sn);
                lcd.cls();
                //------------------------- Define alerts -------------------------
                if((temp>40)||(temp<0)) {
                    alert=1;
                    lcd.locate(0,10);
                    lcd.printf("Temperature!!!");
                    lcd.background(0xFF0000);
                }
                else if (wndspd>4){
                    alert=1;
                    lcd.locate(0,10);
                    lcd.printf("Wind!!!");
                    lcd.background(0xFF0000);
                }
                else if (humdty>95){
                    alert=1;
                    lcd.locate(0,10);
                    lcd.printf("Humidity!!!");
                    lcd.background(0xFF0000);
                }
                else if (sunint<10){
                    alert=1;
                    lcd.locate(0,10);
                    lcd.printf("Cloudy!!!");
                    lcd.background(0xFF0000);
                }
                else if ((3*rngg)>25){
                    alert=1;
                    lcd.locate(0,10);
                    lcd.printf("Flood!!!");
                    lcd.background(0xFF0000);
                }
                else lcd.background(0x0000FF);
                lcd.locate(0,1);
                lcd.printf("WndSPd: %3.1fm/s",wndspd);
                lcd.locate(0,2);
                lcd.printf("WndDir: %3.1fdg",wnddir);
                lcd.locate(0,3);
                lcd.printf("Rain: %3.1fmm/hr",3*rngg);
                lcd.locate(0,4);
                lcd.printf("TEMP: %3.1fC",temp); 
                lcd.locate(0,5);
                lcd.printf("Humidity: %3.1f%%",humdty); 
                lcd.locate(0,6);
                lcd.printf("Press: %5.1fPa",press); 
                lcd.locate(0,7);
                lcd.printf("Sun: %3.1f%%",sunint);
                wait(1); 
           }
           MyRx=1;
           wait_ms(200);
           MyRx=0;     
        }
    } 
}