#include "mbed.h"
#include "string"
#include "SDFileSystem.h"
 
DigitalOut blue_led(P0_20);
DigitalOut white_led(P0_23);

SDFileSystem sd(P0_9, P0_8, P0_10, P0_15, "sd"); // mosi, miso, sclk, cs

InterruptIn in1(P0_19); //for mbed, p8 GPIO
InterruptIn in2(P0_18); //for mbed, p8 GPIO
Timer t1;
Timer t_real;

I2C i2c(P0_5, P0_4); // sda, scl

//float t_period = 0;                   // This is the period between interrupts in microseconds
//float t_freq = 0;
//float t_freq_k = 0;
//float moi = 0;
int cnt=0;
float f_cnt=0;
char str1[17];
char str2[17];

float t = 0;

//I2C i2c(P0_10, P0_11);
const int AQCM0802_addr = 0x7C;

// unsigned char mode;
unsigned char contrast = 0; // 0-63
//unsigned char contrastFlag = false;
// int CGcounter;
// int FADEcounter;

void lcd_cmd(char x) {
  char data[2];
  data[0] = 0x00; // CO = 0,RS = 0
  data[1] = x;
  i2c.write(AQCM0802_addr, data, 2);
}
 
void lcd_contdata(char x) {
  char data[2];
  data[0] = 0xC0; //0b11000000 CO = 1, RS = 1
  data[1] = x;
  i2c.write(AQCM0802_addr, data, 2);
}
 
void lcd_lastdata(char x) {
  char data[2];
  data[0] = 0x40; //0b11000000 CO = 0, RS = 1
  data[1] = x;
  i2c.write(AQCM0802_addr, data, 2);
}
 
void lcd_printStr(const char *s) {
  while(*s) {
    if(*(s + 1)) {
      lcd_contdata(*s);
    } else {
      lcd_lastdata(*s);
    }
    s++;
  }
}
 
void lcd_printHex(unsigned char num) {
  lcd_contdata(num);
}
 
void lcd_init() {
  wait(0.04);
  // LCD initialize
  lcd_cmd(0x38); // function set
  lcd_cmd(0x39); // function set
  lcd_cmd(0x04); // EntryModeSet
  lcd_cmd(0x14); // interval osc
  lcd_cmd(0x70 | (contrast & 0xF)); // contrast Low
  lcd_cmd(0x5C | ((contrast >> 4) & 0x3)); // contast High/icon/power
  lcd_cmd(0x6C); // follower control
  wait(0.2);
  lcd_cmd(0x38); // function set
  lcd_cmd(0x0C); // Display On
  lcd_cmd(0x01); // Clear Display
  wait(0.2); // need additional wait to Clear Display
}
 
void lcd_setCursor(unsigned char x,unsigned char y) {
  lcd_cmd(0x80 | (y * 0x40 + x));
}
 
void setContrast(unsigned char c) {
  lcd_cmd(0x39);
  lcd_cmd(0x70 | (c & 0x0f)); // contrast Low
  lcd_cmd(0x5C | ((c >> 4) & 0x03)); // contast High/icon/power
  lcd_cmd(0x38);
}
 
void flip1(){
        lcd_setCursor(0, 1);
        lcd_printStr("sw1");
        white_led=1;
        wait(0.5);
        lcd_setCursor(0, 1);
        lcd_printStr("   ");
}

void flip2(){
        lcd_setCursor(4, 1);
        lcd_printStr("sw2");
        white_led=0;
        wait(0.5);
        lcd_setCursor(4, 1);
        lcd_printStr("   ");
}

int main() {
    white_led = 1;
    
    // LCD init
    lcd_init();
    contrast = 35;
    setContrast(contrast);
    lcd_printStr("...");
    
    // Timer start
    t1.start();
    t_real.start();
    
    // Interuupt start
    in1.mode(PullUp);  // Set the pin to Pull Down mode.
    in1.fall(&flip1);    // Set up the interrupt for rising edge
    
    in2.mode(PullUp);  // Set the pin to Pull Down mode.
    in2.fall(&flip2);    // Set up the interrupt for rising edge
 
    white_led=0;
    
    // SD init
    lcd_setCursor(0, 0);
    lcd_printStr("SD:");
    FILE *fp = fopen("/sd/TEST.txt", "w");
    fprintf(fp, "second, time\r\n");
    fclose(fp);
    lcd_printStr("OK");


    while(1) {
        blue_led = 1;
        wait(1);
        blue_led = 0;
        wait(1);
    }
}
