#include "mbed.h"
#include "EthernetNetIf.h"
#include "MySQLClient.h"

#define SQL_SERVER   "192.168.100.204"
#define SQL_USER     "mysql"
#define SQL_PASSWORD "mysql"
#define SQL_DB       "petey"

EthernetNetIf eth; 
MySQLClient sql;

MySQLResult sqlLastResult;
void onMySQLResult(MySQLResult r)
{
  sqlLastResult = r;
}

int main()
{
  printf("Start\n");

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  Host host(IpAddr(), 3306, SQL_SERVER);
  
  //Connect
  sqlLastResult = sql.open(host, SQL_USER, SQL_PASSWORD, SQL_DB, onMySQLResult);
  while(sqlLastResult == MYSQL_PROCESSING)
  {
    Net::poll();
  }
  if(sqlLastResult != MYSQL_OK)
  {
    printf("Error %d during connection\n", sqlLastResult);
  }
  
  //SQL Command
  //Make command
  char cmd[128] = {0};
  const char* msg="1";
  const char* msg2="69.78";
  const char* msg3="70.90";
  const char* msg4="TRIP-A";
  sprintf(cmd, "INSERT INTO location (idlocation, lati, long, tripid) VALUES('%s')", msg,msg2,msg3,msg4);
  
  //INSERT INTO DB
  string cmdStr = string(cmd); 
  sqlLastResult = sql.sql(cmdStr);
  while(sqlLastResult == MYSQL_PROCESSING)
  {
    Net::poll();
  }
  if(sqlLastResult != MYSQL_OK)
  {
    printf("Error %d during SQL Command\n", sqlLastResult);
  }
  
  sql.exit();
  
  while(1)
  {
  
  }
  
  return 0;
}