#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"


#include "mbed.h"
int RSX,RSY,LSX,LSY,BSU,BSL;
int a,b,c,d,e,f,g,h;
int send=0;



//これより下に関数外に書く要素を記入する
PwmOut led1(LED1);
PwmOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

SPI spi(p5,p6,p7);
DigitalOut cs(p8);

void UserLoopSetting()
{
    //一度だけ行いたい初期設定をここに書く
    led1.period_ms(20);
    spi.format(8,3);
    spi.frequency(1000000);

}

void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0) { //有線Ps3USB.cpp
        RSX = ((ps3report*)data)->RightStickX;
        RSY = ((ps3report*)data)->RightStickY;
        LSX = ((ps3report*)data)->LeftStickX;
        LSY = ((ps3report*)data)->LeftStickY;
        BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)data)->ButtonState;
    } else {//無線TestShell.cpp
        RSX = ((ps3report*)(data + 1))->RightStickX;
        RSY = ((ps3report*)(data + 1))->RightStickY;
        LSX = ((ps3report*)(data + 1))->LeftStickX;
        LSY = ((ps3report*)(data + 1))->LeftStickY;
        BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)(data + 1))->ButtonState;
    }
    //ここより下にプログラムを書く

    
    send =a+b+c+d+e+f+g+h;


    if((ButtonState >> BUTTONUP)&1 == 1) { // ▲で燃料用アーム展開
        a= 1;
    } else {
        a= 0;
    }

    if((ButtonState >> BUTTONTRIANGEL)&1 == 1) { // △で燃料回収
        b= 2;
    } else {
        b= 0 ;
    }

    if((ButtonState >> BUTTONLEFT)&1 == 1) { // ◀で燃料掃き出し
        c= 4;
    } else {
        c= 0;
    }

    if((ButtonState >> BUTTONCIRCLE)&1 == 1) { // 〇でタンク回収
        d= 8;
    } else {
        d= 0;
    }

    if((ButtonState >> BUTTONRIGHT)&1 == 1) { // ‣でタンク掃き出し
        e= 16;
    } else {
        e= 0;
    }

    if((ButtonState >> BUTTONDOWN)&1 == 1) { // ▼で待機
        f= 32;
    } else {
        f= 0;
    }

    if((ButtonState >> BUTTONCROSS)&1 == 1) { // ×でサンプル受け取り
        g= 64;
    } else {
        g= 0;
    }

    if((ButtonState >> BUTTONSQUARE)&1 == 1) { // □でサンプル設置
        h= 128;
    } else {
        h= 0;
    }

    cs= 0;
    spi.write(send);
    cs= 1;
    //printf("%d\r\n",send);


}