/** @file bitmap.h */
#include "mbed.h"

/** A class to communicate a bitmap
 *
 */
class bitmap {
public:

    /** convert RGB888 to bitmap
     *
     * @param file_name save file name
     * @param buf data buffer address
     * @param pic_width picture width
     * @param pic_height picture height
     * @return save data size
     */
    int Rgb888ToBmp(char * file_name, uint8_t * buf, unsigned long pic_width, unsigned long pic_height) {
        unsigned long offset_size = 54;
        unsigned long buf_stride = (((pic_width * 4u) + 31u) & ~31u);
        unsigned long pic_size = buf_stride * pic_height;
        unsigned long file_size = 0;
        int save_file_size = 0;
        int write_index = (buf_stride * pic_height) - buf_stride;
        unsigned long cnt;
        uint8_t wk_bitmap_buf[16];
        FILE * fp = fopen(file_name, "w");

        if (fp != NULL) {
            file_size = pic_size + offset_size;

            /* BITMAPFILEHEADER */
            wk_bitmap_buf[0]  = 'B';
            wk_bitmap_buf[1]  = 'M';
            wk_bitmap_buf[2]  = (unsigned char)(file_size >> 0);   /* bfSize */
            wk_bitmap_buf[3]  = (unsigned char)(file_size >> 8);   /* bfSize */
            wk_bitmap_buf[4]  = (unsigned char)(file_size >> 16);  /* bfSize */
            wk_bitmap_buf[5]  = (unsigned char)(file_size >> 24);  /* bfSize */
            wk_bitmap_buf[6]  = 0;  /* bfReserved1 */
            wk_bitmap_buf[7]  = 0;  /* bfReserved1 */
            wk_bitmap_buf[8]  = 0;  /* bfReserved2 */
            wk_bitmap_buf[9]  = 0;  /* bfReserved2 */
            wk_bitmap_buf[10] = (unsigned char)(offset_size >> 0);   /* bfOffBits */
            wk_bitmap_buf[11] = (unsigned char)(offset_size >> 8);   /* bfOffBits */
            wk_bitmap_buf[12] = (unsigned char)(offset_size >> 16);  /* bfOffBits */
            wk_bitmap_buf[13] = (unsigned char)(offset_size >> 24);  /* bfOffBits */
            fwrite(wk_bitmap_buf, sizeof(char), 14, fp);

            /* BITMAPINFOHEADER */
            wk_bitmap_buf[0]  = 40; /* biSize */
            wk_bitmap_buf[1]  = 0;  /* biSize */
            wk_bitmap_buf[2]  = 0;  /* biSize */
            wk_bitmap_buf[3]  = 0;  /* biSize */
            wk_bitmap_buf[4]  = (unsigned char)(pic_width >> 0);    /* biWidth */
            wk_bitmap_buf[5]  = (unsigned char)(pic_width >> 8);    /* biWidth */
            wk_bitmap_buf[6]  = (unsigned char)(pic_width >> 16);   /* biWidth */
            wk_bitmap_buf[7]  = (unsigned char)(pic_width >> 24);   /* biWidth */
            wk_bitmap_buf[8]  = (unsigned char)(pic_height >> 0);   /* biHeight */
            wk_bitmap_buf[9]  = (unsigned char)(pic_height >> 8);   /* biHeight */
            wk_bitmap_buf[10] = (unsigned char)(pic_height >> 16);  /* biHeight */
            wk_bitmap_buf[11] = (unsigned char)(pic_height >> 24);  /* biHeight */
            wk_bitmap_buf[12] = 1;  /* biPlanes */
            wk_bitmap_buf[13] = 0;  /* biPlanes */
            wk_bitmap_buf[14] = 32; /* biBitCount */
            wk_bitmap_buf[15] = 0;  /* biBitCount */
            fwrite(wk_bitmap_buf, sizeof(char), 16, fp);

            wk_bitmap_buf[0]  = 0;  /* biCopmression */
            wk_bitmap_buf[1]  = 0;  /* biCopmression */
            wk_bitmap_buf[2]  = 0;  /* biCopmression */
            wk_bitmap_buf[3]  = 0;  /* biCopmression */
            wk_bitmap_buf[4]  = (unsigned char)(pic_size >> 0);   /* biSizeImage */
            wk_bitmap_buf[5]  = (unsigned char)(pic_size >> 8);   /* biSizeImage */
            wk_bitmap_buf[6]  = (unsigned char)(pic_size >> 16);  /* biSizeImage */
            wk_bitmap_buf[7]  = (unsigned char)(pic_size >> 24);  /* biSizeImage */
            wk_bitmap_buf[8]  = 0;  /* biXPixPerMeter */
            wk_bitmap_buf[9]  = 0;  /* biXPixPerMeter */
            wk_bitmap_buf[10] = 0;  /* biXPixPerMeter */
            wk_bitmap_buf[11] = 0;  /* biXPixPerMeter */
            wk_bitmap_buf[12] = 0;  /* biYPixPerMeter */
            wk_bitmap_buf[13] = 0;  /* biYPixPerMeter */
            wk_bitmap_buf[14] = 0;  /* biYPixPerMeter */
            wk_bitmap_buf[15] = 0;  /* biYPixPerMeter */
            fwrite(wk_bitmap_buf, sizeof(char), 16, fp);

            wk_bitmap_buf[0]  = 0;  /* biClrUsed */
            wk_bitmap_buf[1]  = 0;  /* biClrUsed */
            wk_bitmap_buf[2]  = 0;  /* biClrUsed */
            wk_bitmap_buf[3]  = 0;  /* biClrUsed */
            wk_bitmap_buf[4]  = 0;  /* biCirImportant */
            wk_bitmap_buf[5]  = 0;  /* biCirImportant */
            wk_bitmap_buf[6]  = 0;  /* biCirImportant */
            wk_bitmap_buf[7]  = 0;  /* biCirImportant */
            fwrite(wk_bitmap_buf, sizeof(char), 8, fp);

            save_file_size    = 54;
            for (cnt = 0; cnt < pic_height; cnt ++) {
                save_file_size += fwrite(&buf[write_index], sizeof(char), buf_stride, fp);
                write_index -= buf_stride;
            }
            fclose(fp);
        }

        return (int)save_file_size;
    };
};
