// test for 20X4 LCD displaying RAM address by locate()
//   ym1784 2010/05/14
//
// e.g.
//     01234567890123456789
//    +--------------------+
//   0|80    TextLCD     93|(0,0) .. (19,0)
//   1|C0                D3|(0,1) .. (19,1)
//   2|94      20X4      A7|(0,2) .. (19,2)
//   3|D4                E7|(0,3) .. (19,3)
//    +--------------------+

#include "mbed.h"
#include "TextLCD_20X4.h"

TextLCD_20X4 lcd(p21, p22, p26, p25, p24, p23); // rs, e, d0, d1, d2, d3

int main() {
    lcd.locate(0,0);
    lcd.printf("80");

    lcd.locate(18,0);
    lcd.printf("93");

    lcd.locate(0,1);
    lcd.printf("C0");

    lcd.locate(18,1);
    lcd.printf("D3");

    lcd.locate(0,2);
    lcd.printf("94");

    lcd.locate(18,2);
    lcd.printf("A7");

    lcd.locate(0,3);
    lcd.printf("D4");

    lcd.locate(18,3);
    lcd.printf("E7");

    lcd.locate(6,0);
    lcd.printf("TextLCD");

    lcd.locate(8,2);
    lcd.printf("20X4");
}
