//
//  TB6569.h
//
//  ... Y.Kuroda
//
//  2012.2.1 ... Originally written by Y.Kuroda
//
//
#ifndef _TB6569_H
#define _TB6569_H

class TB6569
{
public:
    TB6569(PinName pwm, PinName in1, PinName in2, PinName vref=NC, PinName alert=NC);

    void  output(void);
    void  output(int _power);       //  -100 ... 100
    void  output(float _power);     //  -1 ... 1
    void  short_break(void);
    void  stop(void);
    void  reset(void);
    void  period_us(int usec) {
        _pwm.period_us(usec);
    };
    void  period_ms(int msec) {
        _pwm.period_ms(msec);
    };
    void  current_control(float vref);
    int   alert(void) {
        return _alert;
    };

public:

    PwmOut      _pwm; // p21, should be one of the following pins p21-p26
    DigitalOut  _in1;
    DigitalOut  _in2;
    AnalogOut   _vref;
    DigitalIn   _alert;
};



#endif  //_TB6569_H
