//
//  TB6569.cpp
//
//  ... Y.Kuroda
//
//  2012.02.01 ... Originally written by Y.Kuroda
//  2013.06.23 ... Originally written by Y.Kuroda
//
//
#include <mbed.h>
#include "TB6569.h"

TB6569::TB6569( PinName pwm, PinName in1, PinName in2, PinName vref, PinName alert)
:   _pwm(pwm),
    _in1(in1),
    _in2(in2),
    _vref(vref),
    _alert(alert)
{
    stop();
    current_control(1.0);   // default = not control current
}

void
TB6569::current_control(float vref)   // Current Control [0 ... 1]
{
    _vref = vref;
}

void
TB6569::output(int power)   // Percent [-100 ... 100]
{
    if(power == 0) {   // stop
        stop();
    } else {
        output((float)power/100);
    }
}

void
TB6569::output(float power) // PWM Duty [-1 ... 1]
{
    if(power> 1) power= 1;
    else
    if(power<-1) power=-1;

    if(power > 0) {
        _pwm = power;
        _in1 = 1;
        _in2 = 0;
    } else {
        _pwm = power;
        _in1 = 0;
        _in2 = 1;
    }
}

void
TB6569::short_break(void)
{
    _pwm = 0;
    _in1 = 1;
    _in2 = 1;
}

void
TB6569::stop(void)
{
    _pwm = 0;
    _in1 = 0;
    _in2 = 0;
}

void
TB6569::reset(void)
{
    stop();
}
