/*
 *    Example Main
 */
#include "mbed.h"
#include "RingBuffer.h"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
RingBuffer rb(30);


void
save_thread(void const *argument)
{
    while (true) {

        for(int i='A'; i<='Z'; i++) {
            led2 = !led2;
            rb.save(i);
            wait(1);
        }
    }
}


void
save_thread2(void const *argument)
{
    while (true) {

        for(int i='0'; i<='9'; i++) {
            led3 = !led3;
            rb.save(i);
            wait(1);
        }
    }
}


int
main(void)
{
    Thread thread(save_thread);
    Thread thread2(save_thread2);

    while(true) {
        led1 = !led1;
        if(rb.check()) {
            int c = rb.read();
            pc.putc(c);
            if(c=='Z') pc.putc('\n');

        } else {
            wait(0.1);
        }
    }
    return 0;
}
