//
//  Counter Class
//
//  2019.10.13 ... Originally written by Y.Kuroda
//
#ifndef _COUNTER_H
#define _COUNTER_H

class Counter {
  public:
    Counter(PinName pin) : _interrupt(pin), _count(0) {       // create the InterruptIn on the pin specified to Counter
        _interrupt.rise(callback(this, &Counter::increment)); // attach increment function of this counter instance
        _interrupt.fall(callback(this, &Counter::increment)); // attach increment function of this counter instance
    }

    void increment() { _count++; }
    int read() { return _count; }
    int set(int c) { return _count=c; }
    int reset(){ return set(0); }

    int operator=(int c) { return set(c); }
    operator int() { return read(); }
    Counter& operator=(Counter& c){ _count=c.read(); return *this; }

  protected:
    InterruptIn _interrupt;
    volatile int _count;
};

#endif

