// Divided Voltage ... Mechatronics example
//
// 2017.10.05 ... Y.Kuroda
//
#include "mbed.h"

DigitalOut myled(LED1);
AnalogIn a0(A0);

const float vcc = 3.3;  // Vcc voltage
const float r1 = 10;    // R1 [k-ohm]
const float r2 = 30;    // R2 [] 

int main() {
    while(1) {
        myled = !myled; // LED is toggled

        float vo = a0.read()*vcc;   // Vo (analog voltage)
        float vp = r2/(r1+r2) * vo;        
        printf("Analog %7.1f [v]\n", vp);
    }
}
