//
//  Encoder Class
//
//  2019.10.13 ... Originally written by Y.Kuroda
//
#ifndef _COUNTER_H
#define _COUNTER_H

class Encoder {
  public:
    Encoder(PinName pin) : _interrupt(pin), _count(0) {       // create the InterruptIn on the pin specified to Counter
        _interrupt.rise(callback(this, &Encoder::increment)); // attach increment function of this counter instance
        _interrupt.fall(callback(this, &Encoder::increment)); // attach increment function of this counter instance
    }

    void increment() { _count++; }
    int read() const { return _count; }
    int set(int c) { return _count=c; }
    int reset(){ return set(0); }

    int operator=(int c) { return set(c); }
//    Encoder& operator=(Encoder& c){ return *this; }
//    int operator=(Encoder& c){ return read(); }

    operator int() const { return read(); }

  protected:
    InterruptIn _interrupt;
    volatile int _count;
};

#endif

