//
//  AD7490 ... Analog Devices 16 channels, 1MSPS, 12bit ADC
//
//  2012.08.29 ... Originaly written by Yoji KURODA
//
#include "mbed.h"
#include "AD7490.h"

AD7490::AD7490(SPI _spi, PinName _cs)
:   spi(_spi),
    cs(_cs)
{
    unsigned short x = 0;

    for(int i=0; i<3; i++){
 
        x = 0;    
        x |= CREG_WRITE;
    //    x |= CREG_SEQ;
    //    x |= CREG_SHADOW;
        x |= CREG_ADD3;
        x |= CREG_ADD2;
        x |= CREG_ADD1;
        x |= CREG_ADD0;
        x |= CREG_PM1;
        x |= CREG_PM0;
        x |= CREG_RANGE;
        x |= CREG_CODING;
     
        cs = 0;
        unsigned short ret = spi.write(x<<4);
        cs = 1;
    
//        printf("INIT: send = 0x%X, ret = 0x%X\n", x, ret);
    }
}

unsigned short
AD7490::convert(int ch)
{
    unsigned short x = 0;

    x |= CREG_WRITE;
//    x |= CREG_SEQ;
//    x |= CREG_SHADOW;
//    x |= CREG_ADD3;
//    x |= CREG_ADD2;
//    x |= CREG_ADD1;
    x |= (CREG_ADD0|CREG_ADD1|CREG_ADD2|CREG_ADD3) & (ch<<6);

    x |= CREG_PM1;
    x |= CREG_PM0;
    x |= CREG_RANGE;
    x |= CREG_CODING;

    cs = 0;
    unsigned short ret = spi.write(x<<4);
    cs = 1;

//    printf("send = 0x%X, ch = %2d, ret = %d\n", x, (ret>>12)&0xF, ret&0xFFF);

    return ret;
}

void
AD7490::convert(short data[])
{
    for(int ch=0; ch<16; ch++) data[ch]=0;
    for(int ch=0; ch<16; ch++){
        unsigned short ret = convert(ch);

        data[ ret>>12&0xF ] = ret&0xFFF;
    }
}


unsigned short
AD7490::sequential(int ch)
{
    unsigned short x = 0;

    x |= CREG_WRITE;
    x |= CREG_SEQ;
    x |= CREG_SHADOW;
//    x |= CREG_ADD3;
//    x |= CREG_ADD2;
//    x |= CREG_ADD1;
    x |= (CREG_ADD0|CREG_ADD1|CREG_ADD2|CREG_ADD3) & (ch<<6);

    x |= CREG_PM1;
    x |= CREG_PM0;
    x |= CREG_RANGE;
    x |= CREG_CODING;

    cs = 0;
    unsigned short ret = spi.write(x<<4);
    cs = 1;

    return ret;
}



unsigned short
AD7490::read(void)
{
    unsigned short x = 0;

//    x |= CREG_WRITE;
//    x |= CREG_SEQ;
//    x |= CREG_SHADOW;
//    x |= CREG_ADD3;
//    x |= CREG_ADD2;
//    x |= CREG_ADD1;
//    x |= (CREG_ADD0|CREG_ADD1|CREG_ADD2|CREG_ADD3) & (ch<<6);

//    x |= CREG_PM1;
//    x |= CREG_PM0;
//    x |= CREG_RANGE;
//    x |= CREG_CODING;

    cs = 0;
    unsigned short ret = spi.write(x<<4);
    cs = 1;

//    printf("send = 0x%X, ch = %2d, ret = %d\n", x, (ret>>12)&0xF, ret&0xFFF);

    return ret;
}

void
AD7490::read(short data[])
{
    for(int ch=0; ch<16; ch++) data[ch]=0;
    for(int ch=0; ch<16; ch++){
        unsigned short ret = read();

        data[ ret>>12&0xF ] = ret&0xFFF;
    }
}
