//
//  AD7490 ... Analog Devices 16 channels, 1MSPS, 12bit ADC
//
//  2012.08.29 ... Originaly written by Yoji KURODA
//
#ifndef _AD7490_H
#define _AD7490_H

class AD7490 {
  protected:
    enum CREG {
        CREG_WRITE  = 0x800,
        CREG_SEQ    = 0x400,
        CREG_ADD3   = 0x200,
        CREG_ADD2   = 0x100,
        CREG_ADD1   = 0x080,
        CREG_ADD0   = 0x040,
        CREG_PM1    = 0x020,
        CREG_PM0    = 0x010,
        CREG_SHADOW = 0x008,
        CREG_WEAK   = 0x004,
        CREG_RANGE  = 0x002,
        CREG_CODING = 0x001
    };
    
    SPI spi;
    DigitalOut cs;

    unsigned short read(void);  // dummy read for triggering at sequential mode
    
  public:
    AD7490(SPI _spi, PinName _cs);
    virtual ~AD7490(){};

    unsigned short convert(int ch=0);       // one shot conversion at channel [ch]
    void convert(short data[]);             // convert all (16) channels with one short conv.

    unsigned short sequential(int ch=15);   // start sequential mode from channel [0] to [ch]
    void read(short data[]);                // read [0] to [ch], and copy to user area
};

#endif  // _AD7490_H