#include "mbed.h"
#include "note.h"
#include "TFT_4DGL.h"

#define RATIO   0.66
#define minY    130
#define maxY    430

// extern Serial pc;
extern TFT_4DGL screen;

// Initate an empty note
Note::Note() {
    // Do nothing
}

// Initiate the note object with a certain type
Note::Note(int t) {
    type = t;
    if (t == 1) {
        x = 276.0;
        color = 0xFF0000;
    } else if (t == 2) {
        x = 314.0;
        color = 0x00FF00;
    } else if (t == 3) {
        x = 358.0;
        color = 0x0000FF;
    }
    y = 130.0;
    w = 12.0;
    h = w * RATIO;
    speed = 38.0;
    consumed = 0;
}

Note::~Note() {
    // deletes the node  
}

void Note::updatePosition() {
    y += speed;
    if (type == 1) {
        x += -0.14 * speed;
    } else if (type == 3) {
        x += 0.14 * speed;
    }
    w = 12.0 * (1 + (y - 130.0) / 300.0);
    h = w * RATIO;
}

void Note::drawNote() {
    float oldX = x;
    float oldY = y;
    float oldW = w;
    float oldH = h;
    updatePosition();
    screen.ellipse((int)oldX, (int)oldY, (int)oldW, (int)oldH, 0xD38A41);
    if (y > 420) {
        consumed = 1;
//      delete this;
        return;  
    }
    screen.ellipse((int)x, (int)y, (int)w, (int)h, color);
}