#include "mbed.h"
#include "rtos.h"
#include "TFT_4DGL.h"
#include "note.h"
#include "song.h"
#include <vector>


// Define all the ports
// Serial pc(USBTX, USBRX);
TFT_4DGL screen(p9,p10,p11); // serial tx, serial rx, reset pin;
AnalogIn r1(p18);
AnalogIn r2(p19);
AnalogIn r3(p20);
DigitalOut musicOn(p22);
DigitalIn button(p21);

// Define objects
// Ticker beatCounter;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

//Thread t1;
//Mutex stdio_mutex;

// Define and initiate global variables
std::vector<Note> noteArr; 
int beatNumber = 0;
char buffer[2];
int skipped = 0;
int temp;
int score = 0;
Song s = Song(1);
//float r1;
//float r2;
//float r3;

void initiateScreen() {
    // Initiate the screen and the background
    screen.baudrate(3000000);
    screen.display_control(0x0c, 0x01);
    screen.background_color(0x000000);
    
    // Draw the frame
    screen.rectangle(192, 120, 447, 450, 0xD38A41);
    screen.line(256, 120, 192, 450, 0x96411F);
    screen.line(296, 120, 277, 450, 0x96411F);
    screen.line(332, 120, 362, 450, 0x96411F);
    screen.line(372, 120, 447, 450, 0x96411F);
    screen.triangle(192, 120, 192, 450, 256, 120, 0x000000);
    screen.triangle(372, 120, 447, 450, 447, 120, 0x000000);
    screen.rectangle(447, 120, 450, 450, 0x000000);
    
    screen.rectangle(256, 100, 296, 120, 0xFF0000);
    screen.rectangle(296, 100, 332, 120, 0x00FF00);
    screen.rectangle(332, 100, 372, 120, 0x0000FF);
    
//    screen.rectangle(192,450,277,470,0xFF0000);
//    screen.rectangle(277,450,362,470,0x00FF00);
//    screen.rectangle(362,450,447,470,0x0000FF);
    
    // Define the points
    screen.graphic_string("POINTS:", 30, 100, FONT_8X8, WHITE, 2, 2);
    screen.graphic_string("ROCK YOU", 430, 100, FONT_8X8, WHITE, 2, 2);
    
}

//void beatMover() {
//    
//}   

//void checkHits() {
//
//}

int main() {
    button.mode(PullDown);    
    screen.text_string("DRUM HERO 1.0", 15, 8, FONT_8X8, WHITE);  
    screen.text_string("PRESS THE BUTTON", 14, 16, FONT_8X8, WHITE);
    screen.text_string("TO START", 18, 19, FONT_8X8, WHITE);    
    musicOn = 0;
    while(!musicOn) {
        if(button) {
            musicOn = 1;
        }    
    }    
    // Initiate the screen and the main graphics
    initiateScreen();    
    //t1.start(beatMover);
    // t2.start(checkHits);
    while (true) {        
        // Check if the song is ended
        if (beatNumber < s.length) {
            if (r1 > 0.1) {
                screen.rectangle(192,450,277,470,0xFF0000);
                led1 = 1;
//              if (screen.read_pixel(230, 420) == 0xFF0000) {
//                  score++;
//              }
            } else if (r2 > 0.1) {
                screen.rectangle(277,450,362,470,0x00FF00);
                led2 = 1;
//              if (screen.read_pixel(320, 420) == 0x00FF00) {
//                  score++;
//              }
            } else if (r3 > 0.1) {
                screen.rectangle(362,450,447,470,0x0000FF);
                led3 = 1;
//              if (screen.read_pixel(405, 420) == 0x0000FF) {
//                  score++;
//              }
            } else {
                screen.rectangle(192,450,447,470,0x000000);
                led1 = 0;
                led2 = 0;
                led3 = 0;
            }
            // Read the next beat (0,1,2,3)
            temp = s.notes[beatNumber++];
            // Check if there's a beat/note (not 0)
            if (temp) {
                // If beat/note exists, create the object for it and push
                // it to the array of current notes on the screen
                Note n1 = Note(temp);
                noteArr.push_back(n1);
            }   
            //beatNumber++;                
            for (int i = skipped; i < noteArr.size(); i++) {
                if (noteArr[i].consumed) {
                    skipped += 1;
                } else {
                    //stdio_mutex.lock();
                    noteArr[i].drawNote();
                    //stdio_mutex.unlock();
                }
            }
        } else {
             //stdio_mutex.lock();
             screen.rectangle(0,0,640,480,0x000000);
             screen.graphic_string("GAME OVER", 20, 200, FONT_8X8, WHITE, 2, 2);
             //stdio_mutex.unlock();
             wait(30);               
        }
        sprintf(buffer,"%d",score);
        //stdio_mutex.lock();
        screen.text_string(buffer, 5, 7, FONT_8X8, WHITE);
        //stdio_mutex.unlock();
        wait(0.4);
    }
}