//
// TFT_4DGL is a class to drive 4D Systems TFT touch screens
//
// Copyright (C) <2010> Stephane ROCHON <stephane.rochon at free.fr>
//
// TFT_4DGL is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// TFT_4DGL is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with TFT_4DGL.  If not, see <http://www.gnu.org/licenses/>.

#include "mbed.h"
#include "TFT_4DGL.h"

// overwrite 4DGL library screen size settings in TFT_4DGL.h
#define SIZE_X  479
#define SIZE_Y  639
//

TFT_4DGL ecran(p9,p10,p11); // serial tx, serial rx, reset pin;
Timer t;

int main() {
//    char s[500];
//    int x = 0, y = 0, status, xc = 0, yc = 0;

    ecran.baudrate(128000);
// added - Set Display to 640 by 480 mode
    ecran.display_control(0x0c, 0x01);
    
//    ecran.background_color(DGREY);

    ecran.rectangle(192, 120, 447, 450, 0xD38A41);
    ecran.line(256, 120, 192, 450, 0x96411F);
    ecran.line(296, 120, 277, 450, 0x96411F);
    ecran.line(332, 120, 362, 450, 0x96411F);
    ecran.line(372, 120, 447, 450, 0x96411F);
    ecran.triangle(192, 120, 192, 450, 256, 120, 0x000000);
    ecran.triangle(372, 120, 447, 450, 447, 120, 0x000000);
    ecran.rectangle(447, 120, 450, 450, 0x000000);
    
    ecran.ellipse(314, 132, 12, 8, 0xFF0000);
    ecran.ellipse(276, 132, 12, 8, 0x0000FF);
    ecran.ellipse(352, 132, 12, 8, 0x00FF00);
    
    int i = 0;
    double x = 276;
    double x3 = 352;
    int y = 132;
    int x2 = 314;
    int y2 = 132;
    int y3 = 132;
    int x_len = 12;
    int y_len = 8;
    while(i < 70) {
        i += 1;
        if (i % 8 == 0) {
            x_len += 1;
            y_len += 1;
        }
        y2 += 4;
        y3 += 4;
        y += 4;
        x -= 0.5091;
        x3 += 0.5091;
        ecran.ellipse(x2, y2, x_len, y_len, 0xFF0000);
        ecran.ellipse(x, y, x_len, y_len, 0x0000FF);
        ecran.ellipse(x3, y3, x_len, y_len, 0x00FF00);
        wait(0.1);
        ecran.ellipse(x2, y2, x_len, y_len, 0xD38A41);
        ecran.ellipse(x, y, x_len, y_len, 0xD38A41);
        ecran.ellipse(x3, y3, x_len, y_len, 0xD38A41);
    }  
    
//
    //ecran.background_color(DGREY);
//    ecran.circle(120, 160, 80, 0xFF00FF);
//    ecran.triangle(120, 100, 40, 300, 200, 270, 0x0000FF);
//    ecran.line(0, 0, 239, 319, 0xFF0000);
//    ecran.rectangle(50, 50, 200, 90, 0x00FF00);
//    ecran.ellipse(100, 250, 80, 30, 0xFFFF00);
//    ecran.pixel(120, 160, BLACK);
//    ecran.read_pixel(120, 170);
//    ecran.screen_copy(50, 50, 200, 200, 100, 100);
//    ecran.pen_size(WIREFRAME);
//    ecran.circle(120, 160, 60, BLACK);
//    ecran.set_font(FONT_8X8);
//    ecran.text_mode(TRANSPARENT);
//    ecran.text_char('B', 9, 8, BLACK);
//    ecran.text_char('I',10, 8, BLACK);
//    ecran.text_char('G',11, 8, BLACK);
//    ecran.graphic_char('G', 120, 120, BLACK, 4, 4);
//    ecran.text_string("This is a test of string", 2, 12, FONT_8X8, WHITE);
//    ecran.graphic_string("This is a test of graphic string", 20, 200, FONT_8X8, WHITE, 2, 2);
//    ecran.text_button("OK", UP, 40, 260, 0xFF0000, FONT_8X8, BLACK, 2, 2);
//
//  // delete touch screen demo - no touch on uVGA II
//    ecran.cls();
//    int x = -54;
//    int y = -54;
//    ecran.background_color(BLACK);
//    ecran.circle(x, y, 60, 0xD6A34F);
//    while(1) {
//        ecran.circle(x, y, 60, 0xD6A34F);
//        x = x + 10;
//        y = y + 10;
//        ecran.circle(x, y, 60, 0xD6A34F);
//    }
//        
}