#include "f042k6_flash.h"

#include <string.h>

// Read flash content in this partition.
void FlashPartition::Read(uint32_t offset, char* buf, size_t len) {
    memcpy(buf, (void*)(USER_FLASH_AREA_START + start_addr_ + offset), len);
}

// Write flash content into this partition.
// Returns true for success.
bool FlashPartition::Write(uint32_t offset, const char* buf, size_t len) {
    UnlockControlRegister();

    if (*REG32(FLASH_SR) & SR_BSY) {
        return false;
    }

    *REG32(FLASH_CR) |= CR_PG;
    
    const uint16_t* src = (uint16_t*)buf;
    uint16_t* dst = (uint16_t*)(USER_FLASH_AREA_START + start_addr_ + offset);
    for (int i = 0; i < (len + 1) / 2; i++) {
        *(dst++) = *(src++);
        while (*REG32(FLASH_SR) & SR_BSY);
    }

    *REG32(FLASH_CR) &= ~CR_PG;

    return true;
}

// Erase whole partition
// Returns true for success.
bool FlashPartition::EraseAll() {
    UnlockControlRegister();
    
    if (*REG32(FLASH_SR) & SR_BSY) {
        return false;
    }

    *REG32(FLASH_CR) |= CR_PER;
    
    for (uint32_t page = USER_FLASH_AREA_START + start_addr_;
         page < (USER_FLASH_AREA_START + start_addr_ + size_);
         page += kFlashPageInBytes) {
        *REG32(FLASH_AR) = page;
        *REG32(FLASH_CR) |= CR_STRT;
        while (*REG32(FLASH_SR) & SR_BSY);
    }
    *REG32(FLASH_CR) &= ~CR_PER;

    return true;
}

void FlashPartition::UnlockControlRegister() {
    if (*REG32(FLASH_CR) & CR_LOCK) {
        *REG32(FLASH_KEYR) = 0x45670123;
        *REG32(FLASH_KEYR) = 0xCDEF89AB;
    }
}