#include "mbed.h"
#include "math.h"
#include "rtos.h"
#include "gpio_defs.h"
#include "configure.h"


// Clock 72MHz
// 0.35us : NOP*25.2
// 0.8us  :     57.6
// 0.7us  :     50.4
// 0.6us  :     43.2

inline void sleep0_35us(void)
{
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");

}
inline void sleep0_8us(void)
{
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");

}

inline void sleep0_7us(void)
{
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");

}

inline void sleep0_6us(void)
{
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
}

inline void led_bit_0(void){
    pinLed = 1;
    sleep0_35us();
    pinLed = 0;
    sleep0_8us();
}

inline void led_bit_1(void){
    pinLed = 1;
    sleep0_7us();
    pinLed = 0;
    sleep0_6us();
}


void TaskLed(void const *argument)
{
    int i;
    int j;
    int k;
    int8_t val = 255;
    
    printf("TaskLed started\r\n");
    
    while(1){

        
        for(i=0;i<NUMBER_OF_LEDS;i++){
            for(j=0;j<3;j++){
                for(k=0;k<8;k++){
                    if((val >> (7-k)) & 0x01){
                        led_bit_1();
                    } else {
                        led_bit_0();
                    }
                }
            }
        }
        val-=20;
        Thread::wait(100);
    }
}
/*
 * WS2812 tape led IC
 *
 *          0.35us   0.8us    (+-150ns)
 *  0:     |^^^^^|__________|
 *
 *             0.7us   0.6us  (+-150ns)
 *  1:     |^^^^^^^^^^|_____|
 *
 *               >50us
 *  RESET: |________________|
 */

