#include "mbed.h"
#include "rtos.h"
#include "math.h"
#include "iSDIO.h"
#include "gpio_defs.h"

#ifndef TARGET_NUCLEO_F303K8
#error This program only supports to run on Nucleo F303K8.
#endif

extern void TaskSensor(void const* );
extern void TaskLed(void const* );
extern void TaskFA(void const* );

Thread* threadLed = NULL;
Thread* threadSensor = NULL;
Thread* threadFA = NULL;

Serial pc(USBTX, USBRX);

int main() {
    pc.baud(115200);
    printf("Startup Neon main program\r\n");

    Thread::wait(500); // 適当な待ち時間

    threadLed = new Thread(TaskLed, NULL, osPriorityNormal, DEFAULT_STACK_SIZE, NULL );
    threadSensor = new Thread(TaskSensor, NULL, osPriorityNormal, DEFAULT_STACK_SIZE*2, NULL ); // スタックサイズ未検証
    //threadFA = new Thread(TaskFA, NULL, osPriorityNormal, DEFAULT_STACK_SIZE , NULL );

    while(true){
        StatusLED = 1;
        Thread::wait(800);
        StatusLED = 0;
        Thread::wait(800);
    }
}

