#include "mbed.h"
#include "USBSerial.h"
#include "DHT.h"
#include "SSD1308.h"

#define LOG(...)    serial.printf(__VA_ARGS__)

BusOut leds(LED1, LED2, LED3, LED4);
USBSerial serial;                    // USB serial to output debug message

// Grove - Temperature & Humidity Pro is connected with UART Grove of Seeeduino Arch, uses P1_14
DHT sensor(P1_14, DHT22);            

// Grove - OLED 128x64 is connected with I2C Grove
I2C i2c(P0_5, P0_4);    // SDA, SCL
SSD1308 oled = SSD1308(i2c, SSD1308_SA0);

int main() {
    uint8_t count = 0;
    char display_buf[8];
    int  err;
    float humidity;
    float last_humidity = 0;
    float temperature;
    float last_temperature = 0;
    
    
    LOG("------- Sense -------\n");
    oled.writeString(0, 0, "---- Sense ----");
    oled.writeString(2, 0, "Temperature:");
    oled.writeString(5, 0, "Humidity:");
    while(1) {
        count++;
        leds = count;

        err = sensor.readData();
        if (err == 0) {
            temperature = sensor.ReadTemperature(CELCIUS);
            if (temperature != last_temperature) {   // update temperature if changed
                snprintf(display_buf, sizeof(display_buf), "%4.2f C", temperature);
                oled.writeString(3, 0, display_buf);
                last_temperature = temperature;
            }
            
            humidity = sensor.ReadHumidity();
            if (humidity != last_humidity) {
                snprintf(display_buf, sizeof(display_buf), "%4.2f %%", humidity);
                oled.writeString(6, 0, display_buf);
                last_humidity = humidity;
            }
            
            LOG("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            LOG("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            LOG("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
            LOG("Humidity is %4.2f \r\n",sensor.ReadHumidity());
            LOG("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            LOG("Dew point (fast) is %4.2f  \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
        } else
            LOG("\r\nErr %i \n",err);
            
        wait(2);
    }
}
