
#include "msgpuck.h"    // Must be included before including mbed.h
#include "mbed.h"

DigitalOut myled(LED1);

char buf[64];
char strbuf[32] = {0};
int  strlength = 0;


int msgpuck_test(void)
{
    printf("msgpuck example\n");

    char *w = buf;
    w = mp_encode_array(w, 4);
    w = mp_encode_uint(w, 10);
    w = mp_encode_str(w, "hello msgpuck", strlen("hello msgpuck"));
    w = mp_encode_bool(w, true);
    w = mp_encode_double(w, 3.1415);

    {
        const char *b = buf;
        char *end = w;
        bool is_invalid = mp_check(&b, end);
        if (is_invalid) {
            printf("message invalid\n");
        } else {
            printf("message length: %d\n", end - buf);
        }
    }

    {
        uint32_t size;
        uint64_t ival;
        const char *sval;
        uint32_t sval_len;
        bool bval;
        double dval;

        const char *r = buf;
        size = mp_decode_array(&r);
        /* size is 4 */

        ival = mp_decode_uint(&r);
        /* ival is 10; */
        printf("unsigned int: %u\n", (uint32_t)ival);

        sval = mp_decode_str(&r, &sval_len);
        /* sval is "hello world", sval_len is strlen("hello world") */

        strlength = sval_len;
        if (strlength > (sizeof(strbuf) - 1)) {
            strlength = sizeof(strbuf) - 1;
        }
        memcpy(strbuf, sval, strlength);
        strbuf[strlength] = '\0';
        printf("string length: %d\n", strlength);
        printf("String: %s\n", strbuf);

        bval = mp_decode_bool(&r);
        /* bval is true */
        printf("bool: %s\n", bval ? "true" : "false");

        dval = mp_decode_double(&r);
        /* dval is 3.1415 */
        printf("float: %f\n", dval);

        printf("[%d, \"%s\", %s, %f]\n", (uint32_t)ival, strbuf, bval ? "true" : "false", (float)dval);

        //assert(r == w);
        if (r != w) {
            printf("parse error\n");
        }
    }

    return 0;
}

int main() {
    msgpuck_test();
    
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
