
#include <stdio.h>
#include "spi_api.h"
#include "gpio_api.h"
#include "nrf_delay.h"
#include "nrf51.h"

static spi_t mbed_i2c_object = {0,};
static gpio_t mbed_spi_cs;

void mbed_spi_init(PinName mosi, PinName miso, PinName sclk, PinName cs)
{
    spi_init(&mbed_i2c_object, mosi, miso, sclk, NC);
    spi_format(&mbed_i2c_object, 8, 0, 0);
    spi_frequency(&mbed_i2c_object, 1000000);

    gpio_init_out(&mbed_spi_cs, cs);
    gpio_write(&mbed_spi_cs, 1);
}

int mbed_spi_write(unsigned char reg_addr,
                   unsigned char length,
                   unsigned char const *data)
{
    int i;

    gpio_write(&mbed_spi_cs, 0);
    spi_master_write(&mbed_i2c_object, reg_addr);
    for (i = 0; i < length; i++) {
        spi_master_write(&mbed_i2c_object, data[i]);
    }
    gpio_write(&mbed_spi_cs, 1);
    nrf_delay_us(50);
    return 0;
}

int mbed_spi_read(unsigned char reg_addr,
                  unsigned char length,
                  unsigned char *data)
{
    int i;

    gpio_write(&mbed_spi_cs, 0);
    spi_master_write(&mbed_i2c_object, reg_addr | 0x80);
    for (i = 0; i < length; i++) {
        data[i] = spi_master_write(&mbed_i2c_object, 0xff);
    }

    gpio_write(&mbed_spi_cs, 1);
    nrf_delay_us(50);
    return 0;
}

void mbed_spi_enable(void)
{

}

void mbed_spi_disable(void)
{

}
