#include "mbed.h"
#include "DigitDisplay.h"

DigitDisplay display(P1_14, P1_13); // 4-Digit Display connected to UART Grove connector
DigitalOut led(LED1);
DigitalOut led2(LED2);
Ticker tick;
uint8_t hour = 0;
uint8_t minute = 0;
uint8_t second = 0;
uint8_t colon = 0;

uint8_t display_buffer[4] = {0, 0, 0, 0};

void handler(void)
{
    display.setColon(colon);
    led2 = !led2;
    if (colon) {
        colon = 0;
        
        second++;
        if (second >= 60) {
            second = 0;
            
            minute++;
            if (minute >= 60) {
                minute = 0;
                
                hour++;
                if (hour >= 24) {
                    hour = 0;
                }
            }
            

            display_buffer[0] = hour / 10;
            display_buffer[1] = hour % 10;
            
            display_buffer[2] = minute / 10;
            display_buffer[3] = minute % 10;
            
            display.write(display_buffer);
        }
    } else {
        colon = 1;
    }
}

int main() {
    display.write(display_buffer);
    tick.attach(handler, 0.5);
    while(1) {
        led = !led;
        wait(0.5);
    }
}
