#include "mbed.h"

#define BREATHE_PERIOD         4500    // ms
#define INHALE_PERIOD          (BREATHE_PERIOD / 4)
#define EXHALE_PERIOD          (BREATHE_PERIOD / 2)
#define HOLD_PERIOD            (BREATHE_PERIOD / 8)


BusOut leds(LED1, LED2, LED3, LED4);
PwmOut led(P1_14);

int main() {
    float brightness;
    
    while(1) {
        for (int i = 0; i <= 32; i++) {
            brightness = i * i / (float)(32 * 32);
            led = brightness;
            wait_ms(INHALE_PERIOD / 32);
        }
        
        wait_ms(HOLD_PERIOD);
        
        for (int i = 0; i <= 32; i++) {
            brightness = 1- (i * i / (float)(32 * 32));
            led = brightness;
            wait_ms(EXHALE_PERIOD / 32);
        }
        
        wait_ms(HOLD_PERIOD);
    }
}
