/*
 * Implements a tiny USB disk
 */

#ifndef __USB_TINY_DISK_H__
#define __USB_TINY_DISK_H__

#include "USBMSD.h"

class USBTinyDisk: public USBMSD {
public:
    USBTinyDisk(uint16_t vendor_id = 0x2886, uint16_t product_id = 0x0070, uint16_t product_release = 0x0001);

protected:
    /*
    * read a block on a storage chip
    *
    * @param data pointer where will be stored read data
    * @param block block number
    * @returns 0 if successful
    */
    virtual int disk_read(uint8_t * data, uint64_t block);

    /*
    * write a block on a storage chip
    *
    * @param data data to write
    * @param block block number
    * @returns 0 if successful
    */
    virtual int disk_write(const uint8_t * data, uint64_t block);

    /*
    * Disk initilization
    */
    virtual int disk_initialize();

    /*
    * Return the number of blocks
    *
    * @returns number of blocks
    */
    virtual uint64_t disk_sectors();

    /*
    * Return memory size
    *
    * @returns memory size
    */
    virtual uint64_t disk_size();


    /*
    * To check the status of the storage chip
    *
    * @returns status: 0: OK, 1: disk not initialized, 2: no medium in the drive, 4: write protected
    */
    virtual int disk_status();
    
    /*
    * Get string manufacturer descriptor
    *
    * @returns pointer to the string manufacturer descriptor
    */
    virtual uint8_t * stringImanufacturerDesc();
    
    /*
    * Get string product descriptor
    *
    * @returns pointer to the string product descriptor
    */
    virtual uint8_t * stringIproductDesc();
    
    /*
    * Get string serial descriptor
    *
    * @returns pointer to the string serial descriptor
    */
    virtual uint8_t * stringIserialDesc();
};

#endif
