
#include <stdint.h>
#include "USBTinyDisk.h"

#include "DiskImage.c"  // include DiskImage[]

// Min size of a disk recognized by windows is 8192 bytes
#define DISK_SIZE_MIN           8192
#define DISK_SIZE()             ((sizeof(DiskImage) > DISK_SIZE_MIN) ? sizeof(DiskImage) : DISK_SIZE_MIN)

USBTinyDisk::USBTinyDisk(uint16_t vendor_id, uint16_t product_id, uint16_t product_release) : USBMSD(vendor_id, product_id, product_release) {
    
}

int USBTinyDisk::disk_read(uint8_t * data, uint64_t block) {
    int offset = 512 * block;
    if (offset < sizeof(DiskImage)) {
        memcpy(data, DiskImage + offset, 512);
    } else {
        memset(data, 0, 512);
    }
    return 0;
}

int USBTinyDisk::disk_write(const uint8_t * data, uint64_t block) {
    return 1;
}

int USBTinyDisk::disk_initialize() {
    return 0;
}

uint64_t USBTinyDisk::disk_sectors() {
    
    return DISK_SIZE() / 512;
}

uint64_t USBTinyDisk::disk_size() {
    return DISK_SIZE();
}

int USBTinyDisk::disk_status() {
    return 4;
}

uint8_t * USBTinyDisk::stringImanufacturerDesc() {
    static uint8_t stringImanufacturerDescriptor[] = {
        0x0C,                                           //bLength
        STRING_DESCRIPTOR,                              //bDescriptorType 0x03
        'S',0,'E',0,'E',0,'E',0,'D',0                   //bString iVendor- Seeed
    };
    return stringImanufacturerDescriptor;
}

uint8_t * USBTinyDisk::stringIproductDesc() {
    static uint8_t stringIproductDescriptor[] = {
        0x12,                                           //bLength
        STRING_DESCRIPTOR,                              //bDescriptorType 0x03
        'A',0,'r',0,'c',0,'h',0,' ',0,'P',0,'r',0,'o',0 //bString iProduct - Arch
    };
    return stringIproductDescriptor;
}

uint8_t * USBTinyDisk::stringIserialDesc() {
    static uint8_t stringIserialDescriptor[] = {
        0x12,                                           //bLength
        STRING_DESCRIPTOR,                              //bDescriptorType 0x03
        '2',0,'0',0,'1',0,'3',0,'0',0,'9',0,'2',0,'2',0,'A',0      //bString iSerial - 20130620A
    };
    return stringIserialDescriptor;
}
