/**
 * USB to UART Bridge
 */
 
#include "mbed.h"
#include "USBSerial.h"
#include "BufferedSerial.h"

BufferedSerial uart(P0_19, P0_18, 512);
USBSerial pc;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Ticker ticker;
volatile bool rxflag = false;
volatile bool txflag = false;


#ifdef TARGET_LPC11UXX
#include "LPC11Uxx.h"
void enable_hardware_flow_control()
{
    LPC_IOCON->PIO0_17 = 0x01 | (0x1 << 3);     // RTS, 
    LPC_IOCON->PIO0_7  = 0x01 | (0x1 << 3);     // CTS, pull-down
    
    // enable auto RTS and CTS
    LPC_USART->MCR = (1 << 6) | (1 << 7);
}
#endif


void indicate()
{
    if (rxflag) {
        led3 = !led3;
        rxflag = false;
    } else {
        if (led3) {
            led3 = 0;
        }
    }
    
    if (txflag) {
        led4 = !led4;
        txflag = false;
    } else {
        if (led4) {
            led4 = 0;
        }
    }   
}

// Called by ISR
void settings_changed(int baud, int bits, int parity, int stop)
{
    const Serial::Parity parityTable[] = {Serial::None, Serial::Odd, Serial::Even, Serial::Forced0, Serial::Forced1};
    
    
    led1 = 1;
    if (stop != 2) {
        stop = 1;   // stop bit(s) = 1 or 1.5
    }
    uart.baud(baud);
    uart.format(bits, parityTable[parity], stop);
    led1 = 0;
}


int main()
{
#ifdef TARGET_LPC11UXX
    enable_hardware_flow_control();
#endif
    
    pc.attach(settings_changed);
    ticker.attach_us(indicate, 500);
    
    while (1) {
        while (uart.readable()) {
            rxflag = true;
            char r = uart.getc();
            pc.putc(r);
        }
        
        while (pc.readable()) {
            char r = pc.getc();
            
            txflag = true;
            uart.putc(r);
        }
    }
}
