
#include "mbed.h"
#include "ChainableLED.h"
#include "PN532_SPI.h"
#include "emulatetag.h"
#include "NdefMessage.h"

#include <string.h>

#define LOG(args...)    

BusOut leds(LED1, LED2, LED3, LED4);

ChainableLED rgbled(P1_14, P1_13, 1);

SPI spi(P1_22, P1_21, P1_20);
PN532_SPI interface(spi, P0_2);
EmulateTag nfc(interface);

uint8_t ndefBuf[120];
NdefMessage message;
int messageSize;

uint8_t uid[3] = { 0x12, 0x34, 0x56 };

uint32_t getColor(uint8_t *buf)
{
    uint32_t x = 0;
    for (uint8_t i = 0; i < 8; i++) {
        uint8_t c = *buf;
        if (c >= '0' && c <= '9') {
            x *= 16;
            x += c - '0';
        } else if (c >= 'A' && c <= 'F') {
            x *= 16;
            x += (c - 'A') + 10;
        } else if (c >= 'a' && c <= 'f') {
            x *= 16;
            x += (c - 'a') + 10;
        } else 
            break;

        buf++;
    }

    return x;
}

void processNewNdef(uint8_t *buf, uint16_t length)
{
    NdefMessage msg = NdefMessage(buf, length);

    NdefRecord record = msg.getRecord(0);
    uint8_t recordbuf[32];
    record.getType(recordbuf);
    if (!memcmp(recordbuf, "text/c", 6)) {
        uint8_t r, g, b;
        uint32_t color;
        record.getPayload(recordbuf);
        color = getColor(recordbuf);
        r = (color >> 16) & 0xFF;
        g = (color >> 8) & 0xFF;
        b = color & 0xFF;
        
        rgbled.setColorRGB(0, r, g, b);
        leds = r;
    }
} 

int main()
{
    LOG("------- Emulate Tag --------\n");
    rgbled.setColorRGB(0, 0, 0, 0);

    NdefRecord aarRecord = NdefRecord();
    const uint8_t aarType[] = "android.com:pkg";
    const uint8_t aarPayload[] = "com.seeedstudio.android.nfc.touchpixel";

    aarRecord.setTnf(TNF_EXTERNAL_TYPE);
    aarRecord.setType(aarType, sizeof(aarType) - 1);
    aarRecord.setPayload(aarPayload, sizeof(aarPayload) - 1);

    message = NdefMessage();
    message.addMimeMediaRecord("text/c", "FF000000");
    message.addRecord(aarRecord);
    messageSize = message.getEncodedSize();
    if (messageSize > sizeof(ndefBuf)) {
        while (1) { }
    }

    LOG("Ndef encoded message size: %d\n", messageSize);

    message.encode(ndefBuf);

    // comment out this command for no ndef message
    nfc.setNdefFile(ndefBuf, messageSize);

    // uid must be 3 bytes!
    nfc.setUid(uid);

    nfc.init();

    nfc.attach(processNewNdef);

    while (1) {
        //nfc.setNdefFile(ndefBuf, messageSize);
        nfc.emulate();
    }
}
