#include "mbed.h"
#include "ChainableLED.h"
 
//#define DEBUG
 
#ifdef DEBUG
 
#include "USBSerial.h"
#define LOG(args...)        pc.printf(args)
USBSerial pc;
 
#else
 
#define LOG(args...)
 
#endif  // DEBUG
 
 
// ChainableLED(clk, data, number_of_leds)
ChainableLED color_led(P1_14, P1_13, 1);
AnalogIn thermistor(P0_12);
 
float get_temperature()
{
    unsigned int a, beta = 3975;
    float temperature, resistance;
    
    a = thermistor.read_u16();
    
    /* Calculate the resistance of the thermistor from analog votage read. */
    resistance = (float) 10000.0 * ((65536.0 / a) - 1);
    
    /* Convert the resistance to temperature using Steinhart's Hart equation */
    temperature=(1/((log(resistance/10000.0)/beta) + (1.0/298.15)))-273.15; 
    
    return temperature;
}
 
int temperature2color(float t)
{
    float low  = 26;
    float high = 30;
    int   min = 0;
    int   max = 255;
    int   color;
    
    if (t < low) {
        color = min;
    } else if (t > high) {
        color = max;
    } else {
        color = min + (max - min) * ((t - min) / (max - min));
    }
    
    return color;
}
    
 
int main() {
  
    while(1) {
        float t = get_temperature();
        uint8_t color = temperature2color(t);
        
        LOG("Temperature: %f\r\n", t);
        LOG("Color: %d\r\n", color);
        
        // ChainableLED.setColorRGB(index_of_led, red, green, blue)
        color_led.setColorRGB(0, color, 0xFF - color, 0);
        wait(0.05);
    }
}