#include "mbed.h"
#include "PN532_SPI.h"
#include "NfcAdapter.h"

#if 1                           // Using Seeeduino Arch
#define LOG(args...)
SPI spi(P1_22, P1_21, P1_20);  // SPI(mosi, miso, clk)
PN532_SPI pn532spi(spi, P0_2);

#else                           // Using Arch Pro
#define LOG(args...)        pc.printf(args)
Serial pc(USBTX, USBRX);
SPI spi(P0_18, P0_17, P0_15);
PN532_SPI pn532spi(spi, P0_6);
#endif

NfcAdapter nfc(pn532spi);
DigitalOut led1(LED1);
DigitalOut led2(LED2);

int main() {
    led1 = 1;
    LOG("NFC Writer\n");
    nfc.begin();
    while (1) {
        LOG("\nPlace a formatted Mifare Classic NFC tag on the reader.");
        if (nfc.tagPresent()) {
            led2 = 1;
            NdefMessage message = NdefMessage();
            message.addUriRecord("http://seeedstudio.com");
            bool success = nfc.write(message);
            if (success) {
                LOG("Success. Try reading this tag with your phone.");        
            } else {
                LOG("Write failed.");
            }
            led2 = 0;
        }
        wait(5);
    }
}
