#include "mbed.h"
#include "PN532_SPI.h"
#include "NfcAdapter.h"

#if 0                           // Using Seeeduino Arch
#define LOG(args...)
SPI spi(P1_22, P1_21, P1_20);  // SPI(mosi, miso, clk)
PN532_SPI pn532spi(spi, P0_2);

#else                           // Using Arch Pro
#define LOG(args...)        pc.printf(args)
Serial pc(USBTX, USBRX);
SPI spi(P0_18, P0_17, P0_15);
PN532_SPI pn532spi(spi, P0_6);
#endif

NfcAdapter nfc(pn532spi);
DigitalOut led(LED1);


int main() {
    LOG("NDEF Reader\n");
    nfc.begin();
    while (1) {
        LOG("\nScan a NFC tag\n");
        if (nfc.tagPresent()) {
            NfcTag tag = nfc.read();        // tag.print() doesn't work yet
            if (tag.hasNdefMessage()) {
                LOG("Get a NDEF message.");
                NdefMessage message = tag.getNdefMessage();
            }
        }
        wait(5);
    }
}
