#include "mbed.h"
#include "PN532_SPI.h"
#include "snep.h"
#include "NdefMessage.h"

#if 1                           // Using Seeeduino Arch
#define LOG(args...)
SPI spi(P1_22, P1_21, P1_20);  // SPI(mosi, miso, clk)
PN532_SPI pn532spi(spi, P0_2);

#else                           // Using Arch Pro
#define LOG(args...)        pc.printf(args)
Serial pc(USBTX, USBRX);
SPI spi(P0_18, P0_17, P0_15);
PN532_SPI pn532spi(spi, P0_6);
#endif

DigitalOut led(LED1);
SNEP nfc(pn532spi);
uint8_t ndefBuf[128];

int main()
{
    while (1) {
#if 1
        LOG("Send a message to Android");
        NdefMessage message = NdefMessage();
        message.addUriRecord("http://www.seeedstudio.com");
        int messageSize = message.getEncodedSize();
        if (messageSize > sizeof(ndefBuf)) {
            LOG("ndefBuf is too small");
            while (1) {
            }
        } 
        message.encode(ndefBuf);
        if (0 >= nfc.write(ndefBuf, messageSize)) {
            LOG("Failed\n");
        } else {
            LOG("Success\n");
        }
#else
        LOG("Get a message from Android");
        int msgSize = nfc.read(ndefBuf, sizeof(ndefBuf));
        if (msgSize > 0) {
            NdefMessage msg  = NdefMessage(ndefBuf, msgSize);
            msg.print();
            LOG("\nSuccess");
        } else {
            LOG("failed");
        }
#endif
        wait(5);
    }
}