#include "mbed.h"
#include "USBKeyboard.h"
 
//LED1: NUM_LOCK, LED2: CAPS_LOCK, LED3: SCROLL_LOCK
BusOut leds(LED1, LED2, LED3);
USBKeyboard keyboard;
 
int main(void) {
    uint8_t caps;                       // status of CapsLock
    
    while (!keyboard.configured()) {    // wait until keyboard is configured
    }
 
    while (1) {
        leds = keyboard.lockStatus();
        caps = keyboard.lockStatus() & 0x2;
        
        // wait until CapsLock is pressed
        while ((keyboard.lockStatus() & 0x2) == caps) {
            leds = keyboard.lockStatus();
        }
        
        if (!caps) {
            keyboard.keyCode(KEY_CAPS_LOCK);    // lowercase input
        }
        
        // Automatic input
        keyboard.keyCode('r', 0x08);            // win + r
        wait(0.1);
        keyboard.puts("iexplore  http://seeedstudio.com\n\n");
    }
}