#include "mbed.h"
#include "USBKeyboard.h"

//LED1: NUM_LOCK, LED2: CAPS_LOCK, LED3: SCROLL_LOCK
BusOut leds(LED1, LED2, LED3);
DigitalOut button(P1_14);               // Configure P1_14 pin as input
USBKeyboard keyboard;

int main() {
    int buttonPressedCount = 0; 
    
    while (!keyboard.configured()) {    // wait until keyboard is configured
    }
    
    while (1) {
        leds = keyboard.lockStatus();
        
        if (button.read()) {
            buttonPressedCount++;
            if (2 == buttonPressedCount) { // when button is pressed about 0.02s
                keyboard.mediaControl(KEY_MUTE); // send mute key
            }
        } else {
            buttonPressedCount = 0;
        }
        wait(0.01);
    }
}
