/*
Arch Link Test Program for BLE
Jacky Zhang @ 20150526
*/


#define TEST_W5500
#define TEST_SD
//#define TEST_I2C
#define TEST_BLE


#include "mbed.h"
#include "BLE.h"
#include "HealthThermometerService.h"
#include "WIZnetInterface.h"
#include "SDFileSystem.h"

#ifdef TEST_I2C
#include "TSL2561.h"
#endif

//Arch Link
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);

#ifdef TEST_SD
//SD Card
int SD_Test(void);
SDFileSystem sd(SPI_PSELMOSI0, SPI_PSELMISO0, SPI_PSELSCK0, p11, "sd"); // MOSI, MISO, SCK, CS
DirHandle *dir;
FILE *fp;
#endif

#ifdef TEST_W5500
//W5500
#define USE_DHCP 1
#define LOOPBACKPORT    5000
int W5500_Test(void);
SPI spi(SPI_PSELMOSI0, SPI_PSELMISO0, SPI_PSELSCK0); // mosi, miso, sclk
WIZnetInterface ethernet(&spi, p24, p17); // spi, cs, reset
int ret;
const unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x1C,0xAA,0xCA};
#endif

#ifdef TEST_BLE
//BLE
void periodicCallback(void);
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason);
int BLE_Test(void);
BLEDevice ble;
static volatile bool  triggerSensorPolling = false;
const static char     DEVICE_NAME[]        = "Arch Link Test";
static const uint16_t uuid16_list[]        = {GattService::UUID_HEALTH_THERMOMETER_SERVICE};
#endif

#ifdef TEST_I2C
//TSL2561
int I2C_Test(void);
TSL2561 tsl2561(p5, p6);
#endif

int main(void)
{
    dir = (DirHandle *)malloc(sizeof(DirHandle));
    
    wait(0.2);
    pc.baud(115200);
    wait(0.2);
    pc.printf("hello\r\n");
    
//    while(1)
//  {
//      led1 = 1;
//      wait(0.5);
//      led1 = 0;
//      wait(0.5);
//      pc.printf("hello\r\n");
//  }
    
    
    
    #ifdef TEST_W5500
    if(W5500_Test() == 0)
    {
        pc.printf("W5500 tested OK\r\n\r\n");
    }
    else
    {
        pc.printf("W5500 tested NOT OK!\r\n\r\n");
    }
    #endif
    
    #ifdef TEST_SD
    if(SD_Test() == 0)
    {
        pc.printf("SD Card tested OK\r\n\r\n");
    }
    else
    {
        pc.printf("SD Card tested NOT OK!\r\n\r\n");
    }
    #endif
    
    #ifdef TEST_I2C
    if(I2C_Test() == 0)
    {
        pc.printf("I2C tested OK\r\n\r\n");
    }
    else
    {
        pc.printf("I2C tested NOT OK!\r\n\r\n");
    }
    #endif
    
    #ifdef TEST_BLE
    BLE_Test();
    #endif
    
    while (true)
    { 
        wait(0.5);
    }
}

#ifdef TEST_SD
int SD_Test(void)
{
    int result;
    
    pc.printf("checking SD Card...\r\n");
    result = sd.disk_initialize();
    if(result != 0)
    {
        pc.printf("SD Card initialized failed...\r\n");
        return -1;
    }
    else
    {
        pc.printf("SD Card initialized OK\r\n");
    }
    
    uint64_t sectors = sd.disk_sectors();
    unsigned int capacity = sectors / 2 / 1024;
    pc.printf("SD card capacity is: %dMB\r\n", capacity);

    dir = opendir("/sd/testdir");
    if(dir == NULL)
    {
        pc.printf("the folder is not exist, let us create one\r\n");
        result = mkdir("/sd/testdir", 0777);
        if(result != 0)
        {
            pc.printf("mkdir WRONG, %d\r\n", result);
            return -3;
        }
        pc.printf("the folder was created\r\n");
    }
    
    pc.printf("open file: sdtest.txt\r\n");
    //w+ 打开可读写文件，若文件存在则文件长度清为零，即该文件内容会消失。若文件不存在则建立该文件
    //a 以附加的方式打开只写文件。若文件不存在，则会建立该文件，如果文件存在，写入的数据会被加到文件尾，即文件原先的内容会被保留。（EOF符保留）
    fp = fopen("/sd/testdir/sdtest.txt", "w+");
    pc.printf("opened\r\n");
    if(fp == NULL)
    {
        pc.printf("Could not open file for write\r\n");
        return -2;
    }

    int num = fprintf(fp, "Hello fun SD Card World!\r\n");
    if(num != strlen("Hello fun SD Card World!\r\n"))
    {
        pc.printf("can't write into sdtested.txt\r\n");
        //fclose(fp);
        //free(dir);
        return -4;
    }
    pc.printf("%d characters was wrote into sdtested.txt\r\n", num);
    
    //fclose(fp);
    //free(dir);
   
    return 0;
}

#endif

#ifdef TEST_W5500
int W5500_Test(void)
{
    mbed_mac_address((char *)MAC_Addr); //Use mbed mac addres
    wait(1);
    pc.printf("Start to test ethernet!\r\n");
    
    #if USE_DHCP
    pc.printf("use DHCP\r\n");
    ret = ethernet.init((unsigned char *)MAC_Addr);
    #else
    pc.printf("do NOT use DHCP\r\n");
    int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
    #endif
    
    if (!ret) {
        pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if (!ret) {
            pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                      ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
            return 0;
        } else {
            pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
            //exit(0);
            return -1;
        }
    } else {
        pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
        //exit(0);
        return -1;
    }
    /*
    TCPSocketServer server;
    server.bind(LOOPBACKPORT);
    server.listen();
    
    while (1) {
        pc.printf("\nWait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 0); // Timeout=0.
        pc.printf("Connection from: %s\r\n", client.get_address());
        while (client.is_connected() == true) {
            int n = client.receive(buffer, sizeof(buffer));
            if(n > 0)
                client.send_all(buffer, n);
            if(client.is_fin_received())
                client.close();
        }
        pc.printf("Disconnected.\r\n");
    }*/
}
#endif

#ifdef TEST_I2C
int I2C_Test(void)
{
    uint16_t light_sensor_id = 0;
    
    light_sensor_id = tsl2561.read_ID();
    pc.printf("check id: %d\r\n", light_sensor_id);
    if(light_sensor_id != 0)
    {
        for(int i = 0; i < 10; i++)
        {
            pc.printf("lux = %f\r\n", tsl2561.lux());
            wait(0.2);
        }
        return 0;
    }
    else
    {
        return -1;
    }
}
#endif

#ifdef TEST_BLE
/* Restart Advertising on disconnection*/
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising();
}

void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */

    /* Note that the periodicCallback() executes in interrupt context, so it is safer to do
     * heavy-weight sensor polling from the main thread. */
    triggerSensorPolling = true;
}

int BLE_Test(void)
{
    pc.printf("begin to test BLE\r\n");
    
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    
    ble.init();
    ble.onDisconnection(disconnectionCallback);
//return 0;
    /* Setup primary service. */
    float currentTemperature = 39.6;
    HealthThermometerService thermometerService(ble, currentTemperature, HealthThermometerService::LOCATION_EAR);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::THERMOMETER_EAR);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(1000); /* 1000ms */
    ble.startAdvertising();
    
    pc.printf("BLE initialized OK\r\n");
    
    while(1)
    {
        if (triggerSensorPolling && ble.getGapState().connected) {
            triggerSensorPolling = false;

            /* Do blocking calls or whatever is necessary for sensor polling. */
            // error = sensor.readData();
            // if (!error) {
            //     thermometerService.updateTemperature(c);
            // }

            /* In our case, we simply update the dummy temperature measurement. */
            currentTemperature += 0.1;
            thermometerService.updateTemperature(currentTemperature);
            pc.printf("data updated\r\n");
        } else {
            ble.waitForEvent();
        }
    }
    
    //return 0;
}
#endif

