
#include <string.h>
#include "mbed.h"
#include "ReceiverIR.h"
#include "DigitDisplay.h"
#include "USBKeyboard.h"

 
ReceiverIR ir_rx(P0_4);
DigitDisplay display(P1_14, P1_13);
USBKeyboard keyboard;
BusOut led(LED1);
Ticker ledTicker;

const uint8_t INFRARED_CODE[][4] = {
{0x00, 0xFF, 0x45, 0xBA},   // Power
{0x00, 0xFF, 0x46, 0xB9},   // Mode
{0x00, 0xFF, 0x47, 0xB8},   // Mute
{0x00, 0xFF, 0x44, 0xBB},   // Play
{0x00, 0xFF, 0x40, 0xBF},   // Prev
{0x00, 0xFF, 0x43, 0xBC},   // Next
{0x00, 0xFF, 0x07, 0xF8},   // EQ
{0x00, 0xFF, 0x15, 0xEA},   // -
{0x00, 0xFF, 0x09, 0xF6},   // +
{0x00, 0xFF, 0x16, 0xE9},   // 0
{0x00, 0xFF, 0x19, 0xE6},   // 
{0x00, 0xFF, 0x0D, 0xF2},   // U/SD
{0x00, 0xFF, 0x0C, 0xF3},   // 1
{0x00, 0xFF, 0x18, 0xE7},   // 2
{0x00, 0xFF, 0x5E, 0xA1},   // 3
{0x00, 0xFF, 0x08, 0xF7},   // 4
{0x00, 0xFF, 0x1C, 0xE3},   // 5
{0x00, 0xFF, 0x5A, 0xA5},   // 6
{0x00, 0xFF, 0x42, 0xBD},   // 7
{0x00, 0xFF, 0x52, 0xAD},   // 8
{0x00, 0xFF, 0x4A, 0xB5}    // 9
};

 
void blink(void) {
    led = !led;
}

int main(void) {
    ledTicker.attach(&blink, 0.5);
    
    while (1) {
        uint8_t rbuffer[32] = {0, };
        int bitlength;
        RemoteIR::Format format;
 
        memset(rbuffer, 0x00, sizeof(rbuffer));
        
        while (ir_rx.getState() != ReceiverIR::Received) {
        }
        bitlength = ir_rx.getData(&format, rbuffer, sizeof(rbuffer) * 8);
        if ((RemoteIR::NEC == format) && (32 == bitlength)) {
            for (int i = 0; i < (sizeof(INFRARED_CODE) / sizeof(INFRARED_CODE[0])); i++) {
                if (0 == memcmp(rbuffer, INFRARED_CODE[i], 4)) {
                    // No i infrared code is matched
                    display.write(i);
                    if (2 == i) {
                        keyboard.mediaControl(KEY_MUTE);
                    } else if (3 == i) {
                        keyboard.mediaControl(KEY_PLAY_PAUSE);
                    } else if (4 == i) {
                        keyboard.mediaControl(KEY_PREVIOUS_TRACK);
                    } else if (5 == i) {
                        keyboard.mediaControl(KEY_NEXT_TRACK);
                    } else if (7 == i) {
                        keyboard.mediaControl(KEY_VOLUME_DOWN);
                    } else if (8 == i) {
                        keyboard.mediaControl(KEY_VOLUME_UP);
                    } else if (12 <= i) {
                        keyboard.putc('1' + i - 12);
                    }
                    break;
                }
            }
        }
    }
}
