#include "mbed.h"
#include "SerialLCD.h"
#include "ds1307.h"
 
SerialLCD lcd(P1_13, P1_14);  // Grove Serial LCD is connected to UART Tx and Rx pins
DS1307 rtc(P0_5, P0_4);    // Grove RTC is connected to I2C SDA(P0_5) and SCL(P0_4)
 
int main() {
    const char *week[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    int sec, min, hour, day, date, month, year;
    char strBuffer[16];
    
    lcd.begin();
    lcd.print("Clock");
    rtc.start_clock();
    rtc.gettime(&sec, &min, &hour, &day, &date, &month, &year);
    if (0 == year) {
        rtc.settime(0, 0, 0, 4, 1, 1, 2014 % 100); // Jan 1st, 2014, Wed, 00:00:00
    }

    while(1) {
        rtc.gettime(&sec, &min, &hour, &day, &date, &month, &year);
        snprintf(strBuffer, sizeof(strBuffer), "%d-%d-%d  %s", 2000 + year, month, date, week[day]);
        lcd.setCursor(0, 0);
        lcd.print(strBuffer);
        snprintf(strBuffer, sizeof(strBuffer), "%d:%d:%d", hour, min, sec);
        lcd.setCursor(0, 1);
        lcd.print(strBuffer);
        wait(0.5);
    }
}


