#include "mbed.h"
#include "DigitDisplay.h"

DigitDisplay display(P1_14, P1_13); // 4-Digit Display connected to UART Grove connector
AnalogIn thermistor(P0_12);         // Thermistor output connected to P0_12

int main() {
    unsigned int a;
    unsigned int beta = 3975;
    float temperature, resistance;
 
    while(1) {
        a = thermistor.read_u16(); /* Read analog value */
        
        /* Calculate the resistance of the thermistor from analog votage read. */
        resistance= (float) 10000.0 * ((65536.0 / a) - 1.0);
        
        /* Convert the resistance to temperature using Steinhart's Hart equation */
        temperature = (1/((log(resistance/10000.0)/beta) + (1.0/298.15)))-273.15; 
        
        display = (int)temperature;
      
        wait(0.5);
    }
}
