/* 
 * ESE 519, Spring 2015, Lab 1
 * Part 5
 * Peter Gebhard, pgeb@seas.upenn.edu
 * Yifeng Yuan, yifengy@seas.upenn.edu
 */
 
#include "mbed.h"

int global_code; //global variable
                 //-1 - error
                 //1 - dot
                 //0 - dash
                 //2 - space
int global_buffer; //stores the codes of each letter
int global_length; //stores the length of a coded word

//Timeout wait_for_timeout;
Timer t;
Timeout timeout_function;
InterruptIn en1(p21); //declear en1 as interrupt input using pin 21
DigitalOut led1(LED1);
InterruptIn en2(p22); //declear en2 as interrupt input using pin 22
//DigitalOut led2(LED2);
DigitalOut dp2(p23);
DigitalOut d(p24);
DigitalOut c(p15);
DigitalOut g(p16);
DigitalOut b(p17);
DigitalOut e(p18);
DigitalOut f(p19);
//DigitalOut a(p20);
DigitalOut a(p8);
AnalogIn an1(p20);
PwmOut pwm1(p25);

void speaker();
void speaker_respond_to_light();
void released();
void depressed();
void light_7seg();
char morse2char(int morse, int length);
int hard_limiter(int duration);
void print_symbol();
void print_word();
void show_letter_7seg(char letter);

char word[10];
int letter[5];


void speaker() {
    if (global_code == 1) {
        pwm1 = 0.2f;
        wait(0.1);
        pwm1 = 0.0f;
        }
    if (global_code == 0) {
        pwm1 = 0.2f;
        wait(0.3);
        pwm1 = 0.0f;
        }
}


void speaker_respond_to_light() {
    float analog_in = an1.read();
    if (analog_in <= 0.275){
        pwm1 = 0.2f;
        wait(0.1);
        pwm1 = 0.0f;
        }
    else {
        pwm1 = 0.2f;
        wait(0.3);
        pwm1 = 0.0f;
        }
}


void depressed() {
    timeout_function.detach();
    t.stop();
    t.reset();
    t.start();

}

void released() {
    t.stop();
    int duration = t.read_ms();
    global_code = hard_limiter(duration);
    //printf("You pressed the key %d\n", global_code);
    //append the new code into buffer
    global_buffer = global_buffer << 1;
    global_buffer = global_buffer + global_code;
    //printf("%d\n",global_buffer);
    //keep tracking length of code
    global_length = global_length + 1;
    light_7seg();
    //speaker make a sound!
    //speaker();
    speaker_respond_to_light();
    t.reset();
    t.start();
    //add timeout
    timeout_function.attach(&print_symbol,0.5);
        
}

void print_symbol() {
    
    char letter;

        //convert code into letter
        letter = morse2char(global_buffer,global_length);
        //display letter
        //printf("%c", letter);
        //show_letter_7seg(letter);
        //clear buffer
        global_buffer = 0;
        //clear length
        //printf("%d\n",global_length);
        global_length = 0;
        
        //a space is detected
        global_code = 2;
        //printf("You pressed the key %d\n", global_code);
        //letter = '_';
        //print letter
        //printf("_");
        
        timeout_function.detach();
        timeout_function.attach(&print_word,1.0);
    
    
}

void print_word() {
    
    printf(" ");
    
}

void light_7seg() {
    
    if (global_code == 1) {
        dp2 = 0;
        wait(0.2);
        dp2 = 1;
    }
    if (global_code == 0) {
        d = 0;
        wait(0.2);
        d = 1;
        }
    
}

void show_letter_7seg(char letter) {
    
    float wait_time = 0.2;
    switch(letter) {
        case 'A':
            e = f = a = b = c = g = 0;
            wait(wait_time);
            e = f = a = b = c = g = 1;
            break;
        case 'C':
            a = f = e = d = 0;
            wait(wait_time);
            a = f = e = d = 1;
            break;
        case 'E':
            a = f = g = e = d = 0;
            wait(wait_time);
            a = f = g = e = d = 1;
            break;
        case 'F':
            a = f = g = e = 0;
            wait(wait_time);
            a = f = g = e = 1;
            break;
        case 'G':
            a = f = e = d = c = 0;
            wait(wait_time);
            a = f = e = d = c = 1;
            break;
        case 'H':
            f = b = g = e = c = 0;
            wait(wait_time);
            f = b = g = e = c = 1;
            break;
        case 'I':
            b = c = 0;
            wait(wait_time);
            b = c = 1;
            break;
        case 'J':
            b = c = d = 0;
            wait(wait_time);
            b = c = d = 1;
            break;
        case 'L':
            f = e = d = 0;
            wait(wait_time);
            f = e = d = 1;
            break;
        case 'O':
            a = f = e = d = c = b = 0;
            wait(wait_time);
            a = f = e = d = c = b = 1;
            break;
        case 'P':
            a = b = g = f = e = 0;
            wait(wait_time);
            a = b = g = f = e = 1;
            break;
        case 'U':
            f = e = d = c = b = 0;
            wait(wait_time);
            f = e = d = c = b = 1;
            break;
        default:
            a = b = c = d = e = f = g = 1;
            break;
    }
}

int hard_limiter(int duration) {
    
    int symbol;
    
    if (duration >= 30 && duration <= 200){
        symbol = 1;
        }
    else if (duration > 200) {
        symbol = 0;
        }
    else {
        symbol = -1;
        }
    return symbol;
    
}


char morse2char(int morse, int length) {
    switch (length) {
        case 1: 
            switch (morse) {
                case 0:
                    return 'T';
                case 1:
                    return 'E';    
            }
        case 2:
            switch (morse) {
                case 0:
                    return 'M';
                case 1:
                    return 'N';
                case 2:
                    return 'A';
                case 3:
                    return 'I'; 
            }
        case 3:
            switch (morse) {
                case 0:
                    return 'O';
                case 1:
                    return 'G';
                case 2:
                    return 'K';
                case 3:
                    return 'D';       
                case 4:
                    return 'W';
                case 5:
                    return 'R';
                case 6:
                    return 'U';
                case 7:
                    return 'S'; 
            }
        case 4:
            switch (morse) {
                case 2:
                    return 'Q';
                case 3:
                    return 'Z';
                case 4:
                    return 'Y';
                case 5:
                    return 'C';
                case 6:
                    return 'X';
                case 7:
                    return 'B';
                case 8:
                    return 'J';
                case 9:
                    return 'P';
                case 11:
                    return 'L';
                case 13:
                    return 'F';
                case 14:
                    return 'V';
                case 15:
                    return 'H';
            }
        case 5:
            switch (morse) {
                case 0:
                    return '0';
                case 1:
                    return '9';
                case 3:
                    return '8';
                case 7:
                    return '7';
                case 15:
                    return '6';
                case 31:
                    return '5';
                case 30:
                    return '4';
                case 28:
                    return '3';
                case 24:
                    return '2';
                case 16:
                    return '1';
            }
    }
    return '\0';
}

int main() {

     //setbuf(stdout,NULL);
     //float analog_in;
     setvbuf(stdout,NULL,_IONBF,0);
     pwm1 = 0.0f;
     a = b = c = d = e = f = g = dp2 = 1;
     en1.rise(&depressed);
     en1.fall(&released);
     t.start();
  
     while (1) {
        wait(0.5);
        //analog_in = an1.read();
        //printf("%0.2f\t",analog_in);
        }
}