/*
#include "mbed.h"


int main() {
    while(1) {
        for (float p = 0.0f; p < 1.0f; p += 0.1f) {
            pwm1 = p;
            wait(0.4);
        }
    }
}
*/

/* 
 * ESE 519, Spring 2015, Lab 1
 * Part 5
 * Peter Gebhard, pgeb@seas.upenn.edu
 * Yifeng Yuan, yifengy@seas.upenn.edu
 */
 
#include "mbed.h"

int global_code; //global variable
                 //-1 - error
                 //1 - dot
                 //0 - dash
                 //2 - space
int global_buffer; //stores the codes of each letter
int global_length; //stores the length of a coded word

//Timeout wait_for_timeout;
Timer t;
InterruptIn en1(p21); //declear en1 as interrupt input using pin 21
DigitalOut led1(LED1);
InterruptIn en2(p22); //declear en2 as interrupt input using pin 22
DigitalOut led2(LED2);
DigitalOut led3(p23);
DigitalOut led4(p24);
PwmOut pwm1(p25);


void released();
void depressed();
void speaker();
void light_7seg();
char morse2char(int morse, int length);
int hard_limiter(int duration);

char word[10];
int letter[5];

void depressed() {
    t.stop();
    int duration = t.read_ms();
    char letter;
    if (duration > 400) {
        //convert code into letter
        letter = morse2char(global_buffer,global_length);
        //display letter
        printf("%c\n", letter);
        //clear buffer
        global_buffer = 0;
        //clear length
        //printf("%d\n",global_length);
        global_length = 0;
        
        //a space is detected
        global_code = 2;
        //printf("You pressed the key %d\n", global_code);
        letter = ' ';
        //print letter
        printf("%c\n",letter);
    }
    t.reset();
    t.start();
}

void released() {
    t.stop();
    int duration = t.read_ms();
    global_code = hard_limiter(duration);
    //printf("You pressed the key %d\n", global_code);
    //append the new code into buffer
    global_buffer = global_buffer << 1;
    global_buffer = global_buffer + global_code;
    //printf("%d\n",global_buffer);
    //keep tracking length of code
    global_length = global_length + 1;
    light_7seg();
    speaker();
    t.reset();
    t.start();
        
}

void speaker() {
    if (global_code == 1) {
        pwm1 = 0.2f;
        wait(0.1);
        pwm1 = 0.0f;
        }
    if (global_code == 0) {
        pwm1 = 0.2f;
        wait(0.3);
        pwm1 = 0.0f;
        }
}

void light_7seg() {
    
    if (global_code == 1) {
        led3 = 0;
        wait(0.2);
        led3 = 1;
    }
    if (global_code == 0) {
        led4 = 0;
        wait(0.2);
        led4 = 1;
        }
    
}

int hard_limiter(int duration) {
    
    int symbol;
    
    if (duration >= 30 && duration <= 200){
        symbol = 1;
        }
    else if (duration > 200) {
        symbol = 0;
        }
    else {
        symbol = -1;
        }
    return symbol;
    
}
/*
int morseStr2int(char* morse) {}
*/

char morse2char(int morse, int length) {
    switch (length) {
        case 1: 
            switch (morse) {
                case 0:
                    return 'T';
                case 1:
                    return 'E';    
            }
        case 2:
            switch (morse) {
                case 0:
                    return 'M';
                case 1:
                    return 'N';
                case 2:
                    return 'A';
                case 3:
                    return 'I'; 
            }
        case 3:
            switch (morse) {
                case 0:
                    return 'O';
                case 1:
                    return 'G';
                case 2:
                    return 'K';
                case 3:
                    return 'D';       
                case 4:
                    return 'W';
                case 5:
                    return 'R';
                case 6:
                    return 'U';
                case 7:
                    return 'S'; 
            }
        case 4:
            switch (morse) {
                case 2:
                    return 'Q';
                case 3:
                    return 'Z';
                case 4:
                    return 'Y';
                case 5:
                    return 'C';
                case 6:
                    return 'X';
                case 7:
                    return 'B';
                case 8:
                    return 'J';
                case 9:
                    return 'P';
                case 11:
                    return 'L';
                case 13:
                    return 'F';
                case 14:
                    return 'V';
                case 15:
                    return 'H';
            }
        case 5:
            switch (morse) {
                case 0:
                    return '0';
                case 1:
                    return '9';
                case 3:
                    return '8';
                case 7:
                    return '7';
                case 15:
                    return '6';
                case 31:
                    return '5';
                case 30:
                    return '4';
                case 28:
                    return '3';
                case 24:
                    return '2';
                case 16:
                    return '1';
            }
    }
    return '\0';
}

int main() {

     led3 = 1;
     led4 = 1;
     pwm1 = 0;
     en1.rise(&depressed);
     en1.fall(&released);
     t.start();
  
     while (1) {
        wait(0.5);
        }
}