/* 
 * ESE 519, Spring 2015, Lab 1
 * Part 5
 * Peter Gebhard, pgeb@seas.upenn.edu
 * Yifeng Yuan, yifengy@seas.upenn.edu
 */
 
#include "mbed.h"

int global_code; //global variable
                 //-1 - error
                 //1 - dot
                 //2 - dash
                 //3 - space
int global_buffer; //stores the codes of each letter
int global_length; //stores the length of a coded word


Timer t; // Adding timer to track timing between key presses
Timeout timeout_function; //
InterruptIn en1(p21); //declare en1 as interrupt input using pin 21
InterruptIn en2(p22); //declare en2 as interrupt input using pin 22
DigitalOut dp2(p23); //7seg decimal point
DigitalOut d(p24); //7seg
DigitalOut c(p15); //7seg
DigitalOut g(p16); //7seg
DigitalOut b(p17); //7seg
DigitalOut e(p18); //7seg
DigitalOut f(p19); //7seg
DigitalOut a(p8); //7seg
PwmOut pwm1(p25); //declare pwm1 as digital output pin that provides pwm wave

// Functions declarations
void released();
void depressed();
void light_7seg();
char morse2char(int morse, int length);
int hard_limiter(int duration);
void print_symbol();
void print_word();
void show_letter_7seg(char letter);

// This function handles what the device should do when a key is pressed
void depressed() {
    timeout_function.detach();
    t.stop();
    t.reset();
    t.start();
}

// This function handles what the device should do when a key is released
void released() {
    t.stop();
    int duration = t.read_ms();
    global_code = hard_limiter(duration);
    //printf("You pressed the key %d\n", global_code);
    //append the new code into buffer
    global_buffer = global_buffer << 1;
    global_buffer = global_buffer + global_code;
    //printf("%d\n",global_buffer);
    //keep tracking length of code
    global_length = global_length + 1;
    light_7seg();
    t.reset();
    t.start();
    //add timeout
    timeout_function.attach(&print_symbol,0.5);
    
}

void print_symbol() {
    
    char letter;

    //convert code into letter
    letter = morse2char(global_buffer,global_length);
    //display letter
    printf("%c", letter);
    show_letter_7seg(letter);
    //clear buffer
    global_buffer = 0;
    //clear length
    //printf("%d\n",global_length);
    global_length = 0;    
    //a space is detected
    global_code = 2;

    timeout_function.detach();
    timeout_function.attach(&print_word,1.5);
}

// This function prints a [space] to signal the end of a word
void print_word() {
    printf(" ");
}

// Light the 7-Segment Display for a dot or dash (depending on the global_code)
void light_7seg() {
    
    if (global_code == 1) {
        dp2 = 0;
        wait(0.2);
        dp2 = 1;
    }
    if (global_code == 0) {
        d = 0;
        wait(0.2);
        d = 1;
        }
}

// This function displays letters on 7-segment LEDs 
void show_letter_7seg(char letter) {
    
    float wait_time = 0.2;
    switch(letter) {
        case 'A':
            e = f = a = b = c = g = 0;
            wait(wait_time);
            e = f = a = b = c = g = 1;
            break;
        case 'C':
            a = f = e = d = 0;
            wait(wait_time);
            a = f = e = d = 1;
            break;
        case 'E':
            a = f = g = e = d = 0;
            wait(wait_time);
            a = f = g = e = d = 1;
            break;
        case 'F':
            a = f = g = e = 0;
            wait(wait_time);
            a = f = g = e = 1;
            break;
        case 'G':
            a = f = e = d = c = 0;
            wait(wait_time);
            a = f = e = d = c = 1;
            break;
        case 'H':
            f = b = g = e = c = 0;
            wait(wait_time);
            f = b = g = e = c = 1;
            break;
        case 'I':
            b = c = 0;
            wait(wait_time);
            b = c = 1;
            break;
        case 'J':
            b = c = d = 0;
            wait(wait_time);
            b = c = d = 1;
            break;
        case 'L':
            f = e = d = 0;
            wait(wait_time);
            f = e = d = 1;
            break;
        case 'O':
            a = f = e = d = c = b = 0;
            wait(wait_time);
            a = f = e = d = c = b = 1;
            break;
        case 'P':
            a = b = g = f = e = 0;
            wait(wait_time);
            a = b = g = f = e = 1;
            break;
        case 'U':
            f = e = d = c = b = 0;
            wait(wait_time);
            f = e = d = c = b = 1;
            break;
        default:
            a = b = c = d = e = f = g = 1;
            break;
    }
}

// This function handles interpretation of the key press duration to a Morse Code symbol (ie. dot, dash, space)
int hard_limiter(int duration) {
    
    int symbol;
    
    // Interpret a dot
    if (duration >= 30 && duration <= 250){
        symbol = 1;
        }
    // Interpret a dash
    else if (duration > 250) {
        symbol = 0;
        }
    // Interpret a space
    else {
        symbol = -1;
        }
    return symbol;
}

// This function takes in the integer value of morse code and the code word length as inputs, and determines the
// letter or number they represent for
char morse2char(int morse, int length) {
    switch (length) {
        case 1: 
            switch (morse) {
                case 0:
                    return 'T';
                case 1:
                    return 'E';    
            }
        case 2:
            switch (morse) {
                case 0:
                    return 'M';
                case 1:
                    return 'N';
                case 2:
                    return 'A';
                case 3:
                    return 'I'; 
            }
        case 3:
            switch (morse) {
                case 0:
                    return 'O';
                case 1:
                    return 'G';
                case 2:
                    return 'K';
                case 3:
                    return 'D';       
                case 4:
                    return 'W';
                case 5:
                    return 'R';
                case 6:
                    return 'U';
                case 7:
                    return 'S'; 
            }
        case 4:
            switch (morse) {
                case 2:
                    return 'Q';
                case 3:
                    return 'Z';
                case 4:
                    return 'Y';
                case 5:
                    return 'C';
                case 6:
                    return 'X';
                case 7:
                    return 'B';
                case 8:
                    return 'J';
                case 9:
                    return 'P';
                case 11:
                    return 'L';
                case 13:
                    return 'F';
                case 14:
                    return 'V';
                case 15:
                    return 'H';
            }
        case 5:
            switch (morse) {
                case 0:
                    return '0';
                case 1:
                    return '9';
                case 3:
                    return '8';
                case 7:
                    return '7';
                case 15:
                    return '6';
                case 31:
                    return '5';
                case 30:
                    return '4';
                case 28:
                    return '3';
                case 24:
                    return '2';
                case 16:
                    return '1';
            }
    }
    return '\0';
}

int main() {

     //setbuf(stdout,NULL);
     setvbuf(stdout,NULL,_IONBF,0);
     //pwm1 = 0.0f;
     a = b = c = d = e = f = g = dp2 = 1;
     en1.rise(&depressed);
     en1.fall(&released);
     t.start();
  
     while (1) {
        wait(0.5);
        }
}