#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "VS1002.h" 
#include <mpr121.h>

//SDFileSystem sd(p5, p6, p7, p8, "sd");
uLCD_4DGL uLCD(p28,p27,p30);
Serial pc(USBTX, USBRX);
VS1002 mp3(p5, p6, p7, p8,"sd",p11, p12 ,p13, p14, p23, p22, p21, p20); 
LocalFileSystem local("local");
//AnalogOut DACout(p18); // used to play sound on speaker
//wave_player waver(&DACout);
//This is for the touchpad
I2C i2c(p9, p10);
InterruptIn interrupt(p26);
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

int start = 0;

int new_song_number=1;  //Variable to store the Song Number
int volume_set=-1;     //Variable to store the Volume
int previous_volume;    //Variable to store the volume when muted
bool pause=false;       //Variable to store the status of Pause button 
bool mute=false;        //Variable to store the status of mute button

int check=0;    //Capacitative touch generates interrupt on both press and release. This variable tracks this and updates only on press.
char *song_name[6]={"18 till I Die","Summer of 69","Boulevard", "Serenity","Crawling","In the end"}; //Array of song names entered manually
int chosennum=-1;
int playing=0;
int score=0;
int fullscore;

Mutex ulcd_mutex;
Mutex sd_mutex;

void fallInterrupt() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    // LED demo mod by J. Hamblen
    //pc.printf("MPR value: %x \r\n", value);
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
    check=1;
    //pc.printf("%d  ",playing);
    //if(!playing){
    chosennum=key_code;
    //}
}

class square {
    public:
    int startx,starty,side,pos;
    

    /*function*/
    square(){};
    square(int sx,int sy,int s,int p):startx(sx),starty(sy),side(s),pos(p){};
    void set(int sx, int sy, int s,int p){startx = sx;starty = sy;side = s;pos = p;};
    // draw the block on the LCD
    void draw() {//draw a empty block on the LCD
        uLCD.rectangle(startx,starty,startx+side,starty+side,0x00FF00);
    }
    void show() {//emerge the color inside the block
        uLCD.filled_rectangle(startx+4, starty+4, startx+side-4, starty+side-4, 0x333300);
        wait(0.1);
        uLCD.filled_rectangle(startx+4, starty+4, startx+side-4, starty+side-4, 0x666600);
        wait(0.1);
        uLCD.filled_rectangle(startx+4, starty+4, startx+side-4, starty+side-4, 0x999900);
        wait(0.1);
        uLCD.filled_rectangle(startx+4, starty+4, startx+side-4, starty+side-4, 0xCCCC00);
        wait(0.1);
        uLCD.filled_rectangle(startx+4, starty+4, startx+side-4, starty+side-4, 0xFFFF00);
        wait(0.1);
        if(pos==chosennum){hit();score++;}
        else{miss();}
    
    }
    void hit()  {
        uLCD.filled_rectangle(startx+4, starty+4, startx+side-4, starty+side-4, 0x00FF00);
        wait(0.1);
        uLCD.filled_rectangle(startx+4, starty+4, startx+side-4, starty+side-4, 0x000000);
    }
    void miss() {
        uLCD.filled_rectangle(startx+4, starty+4, startx+side-4, starty+side-4, 0xFF0000);
        wait(0.1);
        uLCD.filled_rectangle(startx+4, starty+4, startx+side-4, starty+side-4, 0x000000);
    }
};

void graph(void const *args)
{   
    while(!start){wait(0.5);}
    pc.printf("i can start from now");
    ulcd_mutex.lock();
    square a[9];
    a[0].set(1,1,40,1);
    a[1].set(44,1,40,2);
    a[2].set(87,1,40,3);
    a[3].set(1,44,40,5);
    a[4].set(44,44,40,6);
    a[5].set(87,44,40,7);
    a[6].set(1,87,40,9);
    a[7].set(44,87,40,10);
    a[8].set(87,87,40,11);
    a[0].draw();a[1].draw();a[2].draw();
    a[3].draw();a[4].draw();a[5].draw();
    a[6].draw();a[7].draw();a[8].draw();
    
    FILE *fp = fopen("/local/2.txt", "r");
        int screen=-1;
        int waitmm=0;
        int numnode=-1;
        int counter = 0;
        fscanf(fp,"%d",&numnode);
        fullscore=numnode;
        while(counter < numnode) {
        fscanf(fp,"%d %d",&screen, &waitmm);
        //uLCD.printf("%d %d\n", screen, waitmm);
        a[screen].show();
        wait(float(waitmm)/1000);
        counter++;
    }
    ulcd_mutex.unlock();

}

int main() {
    //Thread thread2(speaker);
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    
    Thread thread2(graph);
    
    
    uLCD.cls();
    uLCD.media_init();
    uLCD.set_sector_address(0x0000, 0x0099);
    uLCD.display_video(0,0);
    uLCD.cls();
    
    ulcd_mutex.lock();
    uLCD.printf("This is game of Jubeat\n\npick a song you want to play\n\n1. Lovers on the Sun\n2.Man At Arms\n");
    while(!check){wait(0.1);}
    uLCD.printf("You chosen song: %d",chosennum);
    wait(1);
    uLCD.cls();
    ulcd_mutex.unlock();
    pc.printf("mutex unlocked!\n");
    /*
    square a[9];
    a[0].set(1,1,40);
    a[1].set(44,1,40);
    a[2].set(87,1,40);
    a[3].set(1,44,40);
    a[4].set(44,44,40);
    a[5].set(87,44,40);
    a[6].set(1,87,40);
    a[7].set(44,87,40);
    a[8].set(87,87,40);
    a[0].draw();a[1].draw();a[2].draw();
    a[3].draw();a[4].draw();a[5].draw();
    a[6].draw();a[7].draw();a[8].draw();
    */
    
    mp3._RST = 1; 
    mp3.cs_high();                                  //chip disabled 
    mp3.sci_initialise();                           //initialise MBED 
    mp3.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF)); 
    mp3.sci_write(0x03, 0x9800); 
    mp3.sdi_initialise();
    
    start=1; 
    //while(1)
    //{
         //playing=1;
         mp3.play_song(1);
         //playing=0;
    //}   
    
    ulcd_mutex.lock();
    uLCD.cls();

    uLCD.printf("congratulation!\n\nYour score is:\n\n%d \nout of %d",score,fullscore);
    wait(3);
    ulcd_mutex.unlock();
    while(1){}
    

}
