#include "mbed.h"
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT   7

DigitalOut myled(LED1);

int compare_strings(char [], char []); 

int main (void) 
{
    myled = 1; // LED OFF in WIZwiki-W7500
    int flag=1;

    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x55, 0x51, 0x52}; 
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    while (true) 
    {
        printf("Wait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s
        
        printf("Connection from: %s\r\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\r\n",buffer);
    
            // LED control if received message matches pre-defined command
            char command_buf[256] = {'L', 'E', 'D', '_', 'O', 'N', '\0'};

            char string[256];
            strcpy (string, command_buf);
            printf("Received command : %s\n", string);

            flag = compare_strings(buffer, command_buf);
            
            if (flag == 0) {
              myled = 0; // LED ON in WIZwiki-W7500
              printf("LED is turned on!\r\n");
            }
            else {
              myled = 1;
              printf("LED is turned off!\r\n");
            }
            
            // reverse the message
            char temp;
            for(int f = 0, l = n-1; f<l; f++,l--){
                temp = buffer[f];
                buffer[f] = buffer[l];
                buffer[l] = temp;
                }
            
            // print reversed message to terminal
            printf("Sending message to Client: '%s'\r\n",buffer);
            
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }
    
}

int compare_strings(char a[], char b[])
{
   int c = 0;
 
   while (a[c] == b[c]) {
      if (a[c] == '\0' || b[c] == '\0')
         break;
      c++;
   }
 
   if (a[c] == '\0' && b[c] == '\0')
      return 0;
   else
      return -1;
}
